/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.preferences.editors;

import java.util.Arrays;
import org.eclipse.chemclipse.support.util.FileListUtil;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class FileListEditor
extends ListEditor {
    private String[] filterExtensions;
    private String[] filterNames;

    public FileListEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.initialize(parent);
    }

    public void setFilterExtensionsAndNames(String[] filterExtensions, String[] filterNames) {
        this.filterExtensions = filterExtensions;
        this.filterNames = filterNames;
    }

    protected String createList(String[] items) {
        FileListUtil fileListUtil = new FileListUtil();
        return fileListUtil.createList(items);
    }

    protected String getNewInputObject() {
        String file;
        List list = this.getList();
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText("Select File");
        if (this.filterExtensions != null && this.filterNames != null) {
            dialog.setFilterExtensions(this.filterExtensions);
            dialog.setFilterNames(this.filterNames);
        }
        if ((file = dialog.open()) != null) {
            return this.addFile(file, list);
        }
        return null;
    }

    private void initialize(Composite parent) {
        Composite composite = this.getButtonBoxControl(parent);
        Button button = new Button(composite, 8);
        button.setText("Clear");
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = FileListEditor.this.getList();
                if (list != null) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageBox messageBox = new MessageBox(shell, 448);
                    messageBox.setText("File(s)");
                    messageBox.setMessage("Remove all files from the list?");
                    int decision = messageBox.open();
                    if (decision == 64) {
                        list.removeAll();
                    }
                }
            }
        });
    }

    private String addFile(String file, List list) {
        String[] items = list.getItems();
        if (!this.itemExistsInList(file, items)) {
            return file;
        }
        return null;
    }

    private boolean itemExistsInList(String file, String[] list) {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(file)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String[] parseString(String stringList) {
        FileListUtil fileListUtil = new FileListUtil();
        Object[] files = fileListUtil.parseString(stringList);
        Arrays.sort(files);
        return files;
    }
}

