/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.preferences;

import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.MassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.ui.Activator;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverter;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverterSupport;
import org.eclipse.chemclipse.support.ui.preferences.editors.FileListEditor;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.DoubleFieldEditor;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.FloatFieldEditor;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.RetentionTimeMinutesFieldEditor;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.SpacerFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger logger = Logger.getLogger(PreferencePage.class);

    public PreferencePage() {
        super(0);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("File Identifier Settings.");
    }

    public void createFieldEditors() {
        FileListEditor fileListEditor = new FileListEditor("massSpectraFiles", "Load mass spectrum libraries", this.getFieldEditorParent());
        MassSpectrumConverterSupport massSpectrumConverterSupport = MassSpectrumConverter.getMassSpectrumConverterSupport();
        try {
            String[] extensions = massSpectrumConverterSupport.getFilterExtensions();
            String[] names = massSpectrumConverterSupport.getFilterNames();
            if (extensions.length == names.length) {
                String[] filterExtensions = new String[extensions.length + 1];
                String[] filterNames = new String[extensions.length + 1];
                filterExtensions[0] = "*.*";
                filterNames[0] = "All files";
                int i = 0;
                while (i < extensions.length) {
                    filterExtensions[i + 1] = extensions[i].replace(".", "*.");
                    filterNames[i + 1] = names[i];
                    ++i;
                }
                fileListEditor.setFilterExtensionsAndNames(filterExtensions, filterNames);
            }
        }
        catch (NoConverterAvailableException e) {
            logger.warn((Object)e);
        }
        this.addField((FieldEditor)fileListEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("usePreOptimization", "Use search pre-optimization", this.getFieldEditorParent()));
        String labelTextThreshold = this.getDescription("Threshold pre-optimization", 0.0, 1.0);
        this.addField((FieldEditor)new DoubleFieldEditor("thresholdPreOptimization", labelTextThreshold, 0.0, 1.0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("massSpectrumComparatorId", "Mass Spectrum Comparator Id", MassSpectrumComparator.getAvailableComparatorIds(), this.getFieldEditorParent()));
        String labelTextNumberOfTargets = this.getDescription("Number of Targets", 1.0, 100.0);
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor("numberOfTargets", labelTextNumberOfTargets, this.getFieldEditorParent(), 3);
        integerFieldEditor.setValidRange(1, 100);
        this.addField((FieldEditor)integerFieldEditor);
        this.addField((FieldEditor)new FloatFieldEditor("minMatchFactor", "Min Match Factor", 0.0f, 100.0f, this.getFieldEditorParent()));
        this.addField((FieldEditor)new FloatFieldEditor("minReverseMatchFactor", "Min Reverse Match Factor", 0.0f, 100.0f, this.getFieldEditorParent()));
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("addUnknownMzListTarget", "Add m/z list of unknown if no match is available", this.getFieldEditorParent()));
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor("penaltyCalculation", "Force Match Quality Penalty calculation", 1, IIdentifierSettings.PENALTY_CALCULATION_OPTIONS, this.getFieldEditorParent()));
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new FloatFieldEditor("maxPenalty", "Max Penalty", 0.0f, 100.0f, this.getFieldEditorParent()));
        this.addField((FieldEditor)new FloatFieldEditor("penaltyCalculationLevelFactor", "Penalty Calculation Level Factor", 1.0f, 1000.0f, this.getFieldEditorParent()));
        this.addField((FieldEditor)new RetentionTimeMinutesFieldEditor("retentionTimeWindow", "Retention Time Window (minutes)", 60, 60000, this.getFieldEditorParent()));
        this.addField((FieldEditor)new FloatFieldEditor("retentionIndexWindow", "Retention Index Window", 10.0f, 20.0f, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }

    private String getDescription(String info, double minValue, double maxValue) {
        StringBuilder builder = new StringBuilder();
        builder.append(info);
        builder.append(" (");
        builder.append((int)minValue);
        builder.append(" - ");
        builder.append((int)maxValue);
        builder.append(")");
        return builder.toString();
    }
}

