/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.core.AbstractPeakDetectorCSD;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.processing.IPeakDetectorCSDProcessingInfo;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.processing.PeakDetectorCSDProcessingInfo;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.settings.IPeakDetectorCSDSettings;
import org.eclipse.chemclipse.chromatogram.peak.detector.settings.IPeakDetectorSettings;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IDetectorSlope;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.IRawPeak;
import org.eclipse.chemclipse.chromatogram.peak.detector.support.RawPeak;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.IFirstDerivativePeakDetectorCSDSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.FirstDerivativeDetectorSlope;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.FirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.support.IFirstDerivativeDetectorSlopes;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.support.PeakBuilderCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.miscellaneous.Evaluation;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakDetectorCSD
extends AbstractPeakDetectorCSD {
    private static final Logger logger = Logger.getLogger(PeakDetectorCSD.class);
    private static float NORMALIZATION_BASE = 100000.0f;
    private static int CONSECUTIVE_SCAN_STEPS = 3;
    private static final String DETECTOR_DESCRIPTION = "Peak Detector First Derivative";
    private double threshold = 0.005;
    private boolean includeBackground = false;
    private float minimumSignalToNoiseRatio = 0.0f;
    private WindowSize movingAverageWindow = WindowSize.SCANS_3;

    public IPeakDetectorCSDProcessingInfo detect(IChromatogramSelectionCSD chromatogramSelection, IPeakDetectorCSDSettings peakDetectorSettings, IProgressMonitor monitor) {
        PeakDetectorCSDProcessingInfo processingInfo = new PeakDetectorCSDProcessingInfo();
        processingInfo.addMessages((IProcessingInfo)this.validate((IChromatogramSelection)chromatogramSelection, (IPeakDetectorSettings)peakDetectorSettings, monitor));
        if (!processingInfo.hasErrorMessages()) {
            this.setThresholdValue(peakDetectorSettings);
            this.setIncludeBackground(peakDetectorSettings);
            this.setMinimumSignalToNoiseRation(peakDetectorSettings);
            this.setMovingAverageWindowSize(peakDetectorSettings);
            this.detectPeaks(chromatogramSelection, monitor);
            processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DETECTOR_DESCRIPTION, "Peaks have been detected successfully."));
        }
        return processingInfo;
    }

    public IPeakDetectorCSDProcessingInfo detect(IChromatogramSelectionCSD chromatogramSelection, IProgressMonitor monitor) {
        IFirstDerivativePeakDetectorCSDSettings peakDetectorSettings = PreferenceSupplier.getPeakDetectorCSDSettings();
        return this.detect(chromatogramSelection, peakDetectorSettings, monitor);
    }

    private void setThresholdValue(IPeakDetectorCSDSettings peakDetectorSettings) {
        if (peakDetectorSettings instanceof IFirstDerivativePeakDetectorCSDSettings) {
            IFirstDerivativePeakDetectorCSDSettings firstDerivativePeakDetectorSettings = (IFirstDerivativePeakDetectorCSDSettings)peakDetectorSettings;
            switch (firstDerivativePeakDetectorSettings.getThreshold()) {
                case OFF: {
                    this.threshold = 5.0E-4;
                    break;
                }
                case LOW: {
                    this.threshold = 0.005;
                    break;
                }
                case MEDIUM: {
                    this.threshold = 0.05;
                    break;
                }
                case HIGH: {
                    this.threshold = 0.5;
                    break;
                }
                default: {
                    this.threshold = 0.005;
                }
            }
        }
    }

    private void setIncludeBackground(IPeakDetectorCSDSettings peakDetectorSettings) {
        if (peakDetectorSettings instanceof IFirstDerivativePeakDetectorCSDSettings) {
            IFirstDerivativePeakDetectorCSDSettings firstDerivativePeakDetectorSettings = (IFirstDerivativePeakDetectorCSDSettings)peakDetectorSettings;
            this.includeBackground = firstDerivativePeakDetectorSettings.isIncludeBackground();
        }
    }

    private void setMinimumSignalToNoiseRation(IPeakDetectorCSDSettings peakDetectorSettings) {
        if (peakDetectorSettings instanceof IFirstDerivativePeakDetectorCSDSettings) {
            IFirstDerivativePeakDetectorCSDSettings firstDerivativePeakDetectorSettings = (IFirstDerivativePeakDetectorCSDSettings)peakDetectorSettings;
            this.minimumSignalToNoiseRatio = firstDerivativePeakDetectorSettings.getMinimumSignalToNoiseRatio();
        }
    }

    private void setMovingAverageWindowSize(IPeakDetectorCSDSettings peakDetectorSettings) {
        if (peakDetectorSettings instanceof IFirstDerivativePeakDetectorCSDSettings) {
            IFirstDerivativePeakDetectorCSDSettings firstDerivativePeakDetectorSettings = (IFirstDerivativePeakDetectorCSDSettings)peakDetectorSettings;
            this.movingAverageWindow = firstDerivativePeakDetectorSettings.getMovingAverageWindowSize();
        }
    }

    private void detectPeaks(IChromatogramSelectionCSD chromatogramSelection, IProgressMonitor monitor) {
        IFirstDerivativeDetectorSlopes slopes = this.getFirstDerivativeSlopes(chromatogramSelection);
        List<IRawPeak> rawPeaks = this.getRawPeaks(slopes, monitor);
        this.buildAndStorePeaks(rawPeaks, chromatogramSelection.getChromatogramCSD());
    }

    private void buildAndStorePeaks(List<IRawPeak> rawPeaks, IChromatogramCSD chromatogram) {
        IChromatogramPeakCSD peak = null;
        ScanRange scanRange = null;
        for (IRawPeak rawPeak : rawPeaks) {
            try {
                scanRange = new ScanRange(rawPeak.getStartScan(), rawPeak.getStopScan());
                peak = PeakBuilderCSD.createPeak((IChromatogramCSD)chromatogram, (IScanRange)scanRange, (boolean)this.includeBackground);
                if (!this.isValidPeak(peak)) continue;
                peak.setDetectorDescription(DETECTOR_DESCRIPTION);
                chromatogram.addPeak(peak);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        }
    }

    private IFirstDerivativeDetectorSlopes getFirstDerivativeSlopes(IChromatogramSelectionCSD chromatogramSelection) {
        TotalScanSignals signals = new TotalScanSignals((IChromatogramSelection)chromatogramSelection);
        TotalScanSignalsModifier.normalize((ITotalScanSignals)signals, (float)NORMALIZATION_BASE);
        FirstDerivativeDetectorSlopes slopes = new FirstDerivativeDetectorSlopes((ITotalScanSignals)signals);
        int startScan = signals.getStartScan();
        int stopScan = signals.getStopScan();
        int scan = startScan;
        while (scan < stopScan) {
            ITotalScanSignal s1 = signals.getTotalScanSignal(scan);
            ITotalScanSignal s2 = signals.getNextTotalScanSignal(scan);
            if (s1 != null && s2 != null) {
                Point p1 = new Point((double)s1.getRetentionTime(), (double)s1.getTotalSignal());
                Point p2 = new Point((double)s2.getRetentionTime(), (double)s2.getTotalSignal());
                FirstDerivativeDetectorSlope slope = new FirstDerivativeDetectorSlope((IPoint)p1, (IPoint)p2, s1.getRetentionTime());
                slopes.add(slope);
            }
            ++scan;
        }
        slopes.calculateMovingAverage(this.movingAverageWindow);
        return slopes;
    }

    private List<IRawPeak> getRawPeaks(IFirstDerivativeDetectorSlopes slopes, IProgressMonitor monitor) {
        int size = slopes.size();
        int scanOffset = slopes.getStartScan() - 1;
        int peaks = 1;
        ArrayList<IRawPeak> rawPeaks = new ArrayList<IRawPeak>();
        int i = 1;
        while (i <= size - CONSECUTIVE_SCAN_STEPS) {
            int peakStop;
            int peakStart = this.detectPeakStart(slopes, i, scanOffset);
            int peakMaximum = this.detectPeakMaximum(slopes, peakStart, scanOffset);
            i = peakStop = this.detectPeakStop(slopes, peakMaximum, scanOffset);
            RawPeak rawPeak = new RawPeak(peakStart += scanOffset, peakMaximum += scanOffset, peakStop += scanOffset);
            if (this.isValidRawPeak((IRawPeak)rawPeak)) {
                monitor.subTask("Add peak " + peaks++);
                rawPeaks.add((IRawPeak)rawPeak);
            }
            ++i;
        }
        return rawPeaks;
    }

    private boolean isValidRawPeak(IRawPeak rawPeak) {
        boolean isValid = false;
        int width = rawPeak.getStopScan() - rawPeak.getStartScan() + 1;
        if (width >= 3) {
            isValid = true;
        }
        return isValid;
    }

    private boolean isValidPeak(IChromatogramPeakCSD peak) {
        return peak != null && peak.getSignalToNoiseRatio() >= this.minimumSignalToNoiseRatio;
    }

    private int detectPeakStart(IFirstDerivativeDetectorSlopes slopes, int startScan, int scanOffset) {
        int size = slopes.size();
        int peakStart = size - 1;
        double[] values = new double[CONSECUTIVE_SCAN_STEPS];
        int scan = startScan;
        while (scan <= size - CONSECUTIVE_SCAN_STEPS) {
            IDetectorSlope slope = slopes.getDetectorSlope(scan + scanOffset);
            if (slope.getSlope() > this.threshold) {
                int j = 0;
                while (j < CONSECUTIVE_SCAN_STEPS) {
                    values[j] = slopes.getDetectorSlope(scan + j + scanOffset).getSlope();
                    ++j;
                }
                if (Evaluation.valuesAreGreaterThanThreshold((double[])values, (double)this.threshold) && Evaluation.valuesAreIncreasing((double[])values)) {
                    peakStart = scan;
                    break;
                }
            }
            ++scan;
        }
        return peakStart;
    }

    private int detectPeakMaximum(IFirstDerivativeDetectorSlopes slopes, int startScan, int scanOffset) {
        int size = slopes.size();
        int peakMaximum = startScan;
        int scan = startScan;
        while (scan <= size - CONSECUTIVE_SCAN_STEPS) {
            IDetectorSlope slope = slopes.getDetectorSlope(scan + scanOffset);
            if (slope.getSlope() < 0.0) {
                peakMaximum = scan;
                break;
            }
            ++scan;
        }
        return peakMaximum;
    }

    private int detectPeakStop(IFirstDerivativeDetectorSlopes slopes, int startScan, int scanOffset) {
        int size = slopes.size();
        int peakStop = size - CONSECUTIVE_SCAN_STEPS;
        int scan = startScan;
        while (scan <= size - CONSECUTIVE_SCAN_STEPS) {
            IDetectorSlope slope = slopes.getDetectorSlope(scan + scanOffset);
            if (slope.getSlope() > 0.0) {
                peakStop = scan;
                break;
            }
            ++scan;
        }
        return peakStop;
    }
}

