/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.ext.internal.properties;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.swtchart.IAxis;
import org.swtchart.IDisposeListener;
import org.swtchart.Range;
import org.swtchart.ext.InteractiveChart;
import org.swtchart.ext.internal.properties.AbstractSelectorPage;
import org.swtchart.ext.internal.properties.PropertiesResources;

public class AxisPage
extends AbstractSelectorPage {
    private static final String AXIS_TITLE_FONT = "org.swtchart.axis.title.font";
    private static final String AXIS_TITLE_FOREGROUND = "org.swtchart.axis.title.foreground";
    private IAxis[] axes;
    private IAxis.Direction direction;
    protected Button showTitleButton;
    private Label titleLabel;
    protected Text titleText;
    private Label fontSizeLabel;
    protected Spinner fontSizeSpinner;
    private Label titleColorLabel;
    protected ColorSelector titleColorButton;
    protected Text minRangeText;
    protected Text maxRangeText;
    protected Combo positionCombo;
    protected Button categoryButton;
    protected Button logScaleButton;
    protected boolean[] titleVisibleStates;
    protected String[] titleTexts;
    protected int[] titleFontSizes;
    protected RGB[] titleColors;
    protected double[] minRanges;
    protected double[] maxRanges;
    protected IAxis.Position[] positions;
    protected boolean[] categoryStates;
    protected boolean[] logScaleStates;

    public AxisPage(InteractiveChart chart, PropertiesResources resources, IAxis.Direction direction, String title) {
        super(chart, resources, title, "Axes:");
        this.direction = direction;
        if (direction == IAxis.Direction.X) {
            this.axes = chart.getAxisSet().getXAxes();
        } else if (direction == IAxis.Direction.Y) {
            this.axes = chart.getAxisSet().getYAxes();
        }
        this.titleVisibleStates = new boolean[this.axes.length];
        this.titleTexts = new String[this.axes.length];
        this.titleFontSizes = new int[this.axes.length];
        this.titleColors = new RGB[this.axes.length];
        this.minRanges = new double[this.axes.length];
        this.maxRanges = new double[this.axes.length];
        this.positions = new IAxis.Position[this.axes.length];
        if (direction == IAxis.Direction.X) {
            this.categoryStates = new boolean[this.axes.length];
        }
        this.logScaleStates = new boolean[this.axes.length];
    }

    @Override
    protected String[] getListItems() {
        String[] items = new String[this.axes.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.axes[i].getId());
            ++i;
        }
        return items;
    }

    @Override
    protected void selectInitialValues() {
        int i = 0;
        while (i < this.axes.length) {
            this.titleVisibleStates[i] = this.axes[i].getTitle().isVisible();
            this.titleTexts[i] = this.axes[i].getTitle().getText();
            this.titleFontSizes[i] = this.axes[i].getTitle().getFont().getFontData()[0].getHeight();
            this.titleColors[i] = this.axes[i].getTitle().getForeground().getRGB();
            this.minRanges[i] = this.axes[i].getRange().lower;
            this.maxRanges[i] = this.axes[i].getRange().upper;
            this.positions[i] = this.axes[i].getPosition();
            if (this.direction == IAxis.Direction.X) {
                this.categoryStates[i] = this.axes[i].isCategoryEnabled();
            }
            this.logScaleStates[i] = this.axes[i].isLogScaleEnabled();
            ++i;
        }
    }

    @Override
    protected void updateControlSelections() {
        this.showTitleButton.setSelection(this.titleVisibleStates[this.selectedIndex]);
        this.setControlsEnable(this.titleVisibleStates[this.selectedIndex]);
        this.titleText.setText(this.titleTexts[this.selectedIndex]);
        this.fontSizeSpinner.setSelection(this.titleFontSizes[this.selectedIndex]);
        this.titleColorButton.setColorValue(this.titleColors[this.selectedIndex]);
        this.minRangeText.setText(String.valueOf(this.minRanges[this.selectedIndex]));
        this.maxRangeText.setText(String.valueOf(this.maxRanges[this.selectedIndex]));
        this.positionCombo.setText(String.valueOf((Object)this.positions[this.selectedIndex]));
        this.logScaleButton.setSelection(this.logScaleStates[this.selectedIndex]);
        if (this.direction == IAxis.Direction.X) {
            this.categoryButton.setSelection(this.categoryStates[this.selectedIndex]);
        }
    }

    @Override
    protected void addRightPanelContents(Composite parent) {
        this.addAxisPanel(parent);
        this.addTitleGroup(parent);
    }

    private void addAxisPanel(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(2, true));
        this.createLabelControl(group, "Minimum range value:");
        this.minRangeText = this.createTextControl(group);
        this.minRangeText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AxisPage.this.minRanges[AxisPage.this.selectedIndex] = Double.valueOf(AxisPage.this.minRangeText.getText());
            }
        });
        this.createLabelControl(group, "Maximum range value:");
        this.maxRangeText = this.createTextControl(group);
        this.maxRangeText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AxisPage.this.maxRanges[AxisPage.this.selectedIndex] = Double.valueOf(AxisPage.this.maxRangeText.getText());
            }
        });
        this.createLabelControl(group, "Position:");
        String[] items = new String[]{IAxis.Position.Primary.name(), IAxis.Position.Secondary.name()};
        this.positionCombo = this.createComboControl(group, items);
        this.positionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AxisPage.this.positions[AxisPage.this.selectedIndex] = IAxis.Position.valueOf(AxisPage.this.positionCombo.getText());
            }
        });
        this.logScaleButton = this.createCheckBoxControl(group, "Enable log scale");
        this.logScaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AxisPage.this.logScaleStates[AxisPage.this.selectedIndex] = AxisPage.this.logScaleButton.getSelection();
            }
        });
        if (this.direction == IAxis.Direction.X) {
            this.categoryButton = this.createCheckBoxControl(group, "Enable category");
            this.categoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AxisPage.this.categoryStates[AxisPage.this.selectedIndex] = AxisPage.this.categoryButton.getSelection();
                }
            });
        }
    }

    private void addTitleGroup(Composite parent) {
        Group group = this.createGroupControl(parent, "Title:", false);
        this.showTitleButton = this.createCheckBoxControl((Composite)group, "Show title");
        this.showTitleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible;
                AxisPage.this.titleVisibleStates[AxisPage.this.selectedIndex] = visible = AxisPage.this.showTitleButton.getSelection();
                AxisPage.this.setControlsEnable(visible);
            }
        });
        this.titleLabel = this.createLabelControl((Composite)group, "Text:");
        this.titleText = this.createTextControl((Composite)group);
        this.titleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AxisPage.this.titleTexts[AxisPage.this.selectedIndex] = AxisPage.this.titleText.getText();
            }
        });
        this.fontSizeLabel = this.createLabelControl((Composite)group, "Font size:");
        this.fontSizeSpinner = this.createSpinnerControl((Composite)group, 8, 30);
        this.fontSizeSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AxisPage.this.titleFontSizes[AxisPage.this.selectedIndex] = AxisPage.this.fontSizeSpinner.getSelection();
            }
        });
        this.titleColorLabel = this.createLabelControl((Composite)group, "Color:");
        this.titleColorButton = this.createColorButtonControl((Composite)group);
        this.titleColorButton.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AxisPage.this.titleColors[AxisPage.this.selectedIndex] = AxisPage.this.titleColorButton.getColorValue();
            }
        });
    }

    protected void setControlsEnable(boolean enabled) {
        this.titleLabel.setEnabled(enabled);
        this.titleText.setEnabled(enabled);
        this.fontSizeLabel.setEnabled(enabled);
        this.fontSizeSpinner.setEnabled(enabled);
        this.titleColorLabel.setEnabled(enabled);
        this.titleColorButton.setEnabled(enabled);
    }

    @Override
    public void apply() {
        int i = 0;
        while (i < this.axes.length) {
            this.axes[i].getTitle().setVisible(this.titleVisibleStates[i]);
            this.axes[i].getTitle().setText(this.titleTexts[i]);
            FontData fontData = this.axes[i].getTitle().getFont().getFontData()[0];
            fontData.setHeight(this.titleFontSizes[i]);
            Font font = new Font((Device)Display.getDefault(), fontData);
            this.axes[i].getTitle().setFont(font);
            final String fontKey = AXIS_TITLE_FONT + (Object)((Object)this.axes[i].getDirection()) + this.axes[i].getId();
            if (this.resources.getFont(fontKey) == null) {
                this.axes[i].addDisposeListener(new IDisposeListener(){

                    @Override
                    public void disposed(Event e) {
                        AxisPage.this.resources.removeFont(fontKey);
                    }
                });
            }
            this.resources.put(fontKey, font);
            Color color = new Color((Device)Display.getDefault(), this.titleColors[i]);
            this.axes[i].getTitle().setForeground(color);
            final String colorKey = AXIS_TITLE_FOREGROUND + (Object)((Object)this.axes[i].getDirection()) + this.axes[i].getId();
            if (this.resources.getColor(colorKey) == null) {
                this.axes[i].addDisposeListener(new IDisposeListener(){

                    @Override
                    public void disposed(Event e) {
                        AxisPage.this.resources.removeColor(colorKey);
                    }
                });
            }
            this.resources.put(colorKey, color);
            this.axes[i].setRange(new Range(this.minRanges[i], this.maxRanges[i]));
            this.axes[i].setPosition(this.positions[i]);
            try {
                this.axes[i].enableLogScale(this.logScaleStates[i]);
            }
            catch (IllegalStateException illegalStateException) {
                this.axes[i].enableLogScale(false);
                this.logScaleButton.setSelection(false);
            }
            if (this.direction == IAxis.Direction.X) {
                this.axes[i].enableCategory(this.categoryStates[i]);
            }
            ++i;
        }
    }

    protected void performDefaults() {
        this.titleVisibleStates[this.selectedIndex] = true;
        if (this.direction == IAxis.Direction.X) {
            this.titleTexts[this.selectedIndex] = "X Axis";
            this.categoryStates[this.selectedIndex] = false;
        } else if (this.direction == IAxis.Direction.Y) {
            this.titleTexts[this.selectedIndex] = "Y Axis";
        }
        this.positions[this.selectedIndex] = IAxis.Position.Primary;
        this.titleFontSizes[this.selectedIndex] = 11;
        this.titleColors[this.selectedIndex] = Display.getDefault().getSystemColor(9).getRGB();
        this.minRanges[this.selectedIndex] = 0.0;
        this.maxRanges[this.selectedIndex] = 1.0;
        this.logScaleStates[this.selectedIndex] = false;
        this.updateControlSelections();
        super.performDefaults();
    }
}

