/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.components;

import java.text.Format;
import java.util.ArrayList;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.series.ISeriesSetter;
import org.eclipse.chemclipse.swt.ui.series.MultipleSeries;
import org.eclipse.chemclipse.swt.ui.support.ChartUtil;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.thirdpartylibraries.swtchart.ext.InteractiveChartExtended;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.ICustomPaintListener;
import org.swtchart.IPlotArea;
import org.swtchart.Range;

public abstract class AbstractLineSeriesUI
extends InteractiveChartExtended
implements ISeriesSetter {
    private boolean master = false;
    private IMultipleSeries multipleLineSeries;
    private double maxSignal = 0.0;
    private IAxis xAxisTop;
    private IAxis xAxisBottom;
    private IAxis yAxisLeft;
    private IAxis yAxisRight;
    private IAxisTitles axisTitles;
    private boolean yMinimumToZero = false;
    private double yMaxIntensityAdjusted = 0.0;
    private boolean autoAdjustIntensity = true;
    private boolean suppressHairlineDivider = false;

    public AbstractLineSeriesUI(Composite parent, int style, IAxisTitles axisTitles) {
        super(parent, style);
        this.suspendUpdate(true);
        this.axisTitles = axisTitles;
        this.initialize();
        this.suspendUpdate(false);
    }

    public void updateSelectionManually(IChromatogramSelection chromatogramSelection) {
        ChartUtil.checkAndSetRange(this.xAxisTop, chromatogramSelection.getStartRetentionTime(), chromatogramSelection.getStopRetentionTime());
        this.redraw();
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public void addSeries(ISeries series) {
        if (this.multipleLineSeries != null) {
            this.multipleLineSeries.add(series);
        }
    }

    public IMultipleSeries getMultipleSeries() {
        return this.multipleLineSeries;
    }

    public IAxis getXAxisTop() {
        return this.xAxisTop;
    }

    public IAxis getXAxisBottom() {
        return this.xAxisBottom;
    }

    public IAxis getYAxisLeft() {
        return this.yAxisLeft;
    }

    public IAxis getYAxisRight() {
        return this.yAxisRight;
    }

    public void setMaxSignal(double maxSignal) {
        this.maxSignal = maxSignal;
    }

    public double getMaxSignal() {
        return this.maxSignal;
    }

    public void setYMinimumToZero(boolean yMinimumToZero) {
        this.yMinimumToZero = yMinimumToZero;
    }

    public void dispose() {
        super.dispose();
    }

    public synchronized void redraw() {
        assert (this.yAxisLeft != null) : "The abundance instance must be not null.";
        assert (this.xAxisTop != null) : "The milliseconds instance must be not null.";
        double xMin = this.multipleLineSeries.getXMin();
        double xMax = this.multipleLineSeries.getXMax();
        double yMin = this.yMinimumToZero ? 0.0 : this.multipleLineSeries.getYMin();
        double yMax = this.autoAdjustIntensity ? this.multipleLineSeries.getYMax() : this.yMaxIntensityAdjusted;
        if (xMin < xMax && yMin < yMax) {
            ChartUtil.checkAndSetRange(this.xAxisTop, xMin, xMax);
            ChartUtil.checkAndSetRange(this.yAxisLeft, yMin, yMax);
            this.redrawXAxisBottomScale();
            this.redrawYAxisRightScale();
        }
        this.setTopAndLeftAxisVisibility();
        super.redraw();
    }

    public void redrawXAxisBottomScale() {
        assert (this.xAxisTop != null) : "The xAxisTop instance must be not null.";
        assert (this.xAxisBottom != null) : "The xAxisBottom instance must be not null.";
        Range range = this.xAxisTop.getRange();
        double min = range.lower;
        double max = range.upper;
        ChartUtil.setRange(this.xAxisBottom, min, max);
    }

    public void redrawYAxisRightScale() {
        assert (this.yAxisLeft != null) : "The yAxisLeft instance must be not null.";
        assert (this.yAxisRight != null) : "The yAxisRight instance must be not null.";
        Range range = this.yAxisLeft.getRange();
        double min = ChartUtil.getRelativeAbundance(this.maxSignal, range.lower);
        double max = ChartUtil.getRelativeAbundance(this.maxSignal, range.upper);
        ChartUtil.setRange(this.yAxisRight, min, max);
    }

    public void setSuppressHairlineDivider(boolean suppressHairlineDivider) {
        this.suppressHairlineDivider = suppressHairlineDivider;
    }

    protected void initialize() {
        IPlotArea plotArea = (IPlotArea)this.getPlotArea();
        plotArea.addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                if (!AbstractLineSeriesUI.this.suppressHairlineDivider && PreferenceSupplier.showChromatogramHairlineDivider()) {
                    Color color = e.gc.getForeground();
                    int lineStyle = e.gc.getLineStyle();
                    int lineWidth = e.gc.getLineWidth();
                    e.gc.setForeground(Colors.DARK_RED);
                    e.gc.setLineStyle(4);
                    e.gc.setLineWidth(2);
                    int x = e.width / 2;
                    int y = e.height;
                    e.gc.drawLine(x, 0, x, y);
                    e.gc.setForeground(color);
                    e.gc.setLineStyle(lineStyle);
                    e.gc.setLineWidth(lineWidth);
                }
            }

            public boolean drawBehindSeries() {
                return true;
            }
        });
        this.multipleLineSeries = new MultipleSeries();
        this.getLegend().setVisible(false);
        this.getTitle().setVisible(false);
        this.createPrimaryAxes();
        this.createSecondaryAxes();
        this.setAxesAndBackgroundColors();
        this.getAxisSet().adjustRange();
    }

    protected void deleteAllCurrentSeries() {
        this.multipleLineSeries.removeAll();
        org.swtchart.ISeries[] series = this.getSeriesSet().getSeries();
        ArrayList<String> ids = new ArrayList<String>();
        org.swtchart.ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            org.swtchart.ISeries serie = iSeriesArray[n2];
            ids.add(serie.getId());
            ++n2;
        }
        for (String id : ids) {
            this.getSeriesSet().deleteSeries(id);
        }
    }

    protected void setYMaxIntensityAdjusted(double yMaxIntensityAdjusted) {
        this.yMaxIntensityAdjusted = yMaxIntensityAdjusted;
    }

    protected void setAutoAdjustIntensity(boolean autoAdjustIntensity) {
        this.autoAdjustIntensity = autoAdjustIntensity;
    }

    private void createPrimaryAxes() {
        IAxisSet axisSet = this.getAxisSet();
        this.yAxisLeft = axisSet.getYAxis(0);
        this.yAxisLeft.getTitle().setText(this.axisTitles.getYAxisLeftTitle());
        this.yAxisLeft.setPosition(IAxis.Position.Primary);
        this.yAxisLeft.getTick().setFormat((Format)ValueFormat.getDecimalFormatEnglish((String)"0.0#E0"));
        this.xAxisTop = axisSet.getXAxis(0);
        this.xAxisTop.getTitle().setText(this.axisTitles.getXAxisTopTitle());
        this.xAxisTop.setPosition(IAxis.Position.Secondary);
    }

    private void createSecondaryAxes() {
        IAxisSet axisSet = this.getAxisSet();
        int axisIdMinutes = axisSet.createXAxis();
        this.xAxisBottom = axisSet.getXAxis(axisIdMinutes);
        this.xAxisBottom.getTitle().setText(this.axisTitles.getXAxisBottomTitle());
        this.xAxisBottom.setPosition(IAxis.Position.Primary);
        this.xAxisBottom.getTick().setFormat((Format)ValueFormat.getDecimalFormatEnglish((String)"0.0##"));
        int axisIdAbundanceRelative = axisSet.createYAxis();
        this.yAxisRight = axisSet.getYAxis(axisIdAbundanceRelative);
        this.yAxisRight.getTitle().setText(this.axisTitles.getYAxisRightTitle());
        this.yAxisRight.setPosition(IAxis.Position.Secondary);
        this.yAxisRight.getTick().setFormat((Format)ValueFormat.getDecimalFormatEnglish((String)"0.0##"));
    }

    private void setAxesAndBackgroundColors() {
        assert (this.yAxisLeft != null) : "The abundance instance must be not null.";
        assert (this.xAxisTop != null) : "The milliseconds instance must be not null.";
        assert (this.xAxisBottom != null) : "The minutes instance must be not null.";
        assert (this.yAxisRight != null) : "The relativeAbundance instance must be not null.";
        this.setBackground(Colors.WHITE);
        this.setBackgroundInPlotArea(Colors.WHITE);
        ChartUtil.setAxisColor(this.yAxisLeft, Colors.BLACK);
        ChartUtil.setAxisColor(this.xAxisTop, Colors.BLACK);
        ChartUtil.setAxisColor(this.xAxisBottom, Colors.BLACK);
        ChartUtil.setAxisColor(this.yAxisRight, Colors.BLACK);
    }

    private void setTopAndLeftAxisVisibility() {
        assert (this.xAxisTop != null) : "The milliseconds instance must be not null.";
        assert (this.yAxisRight != null) : "The relativeAbundance instance must be not null.";
        boolean showMilliseconds = PreferenceSupplier.isShowMilliseconds();
        boolean showRelativeIntensity = PreferenceSupplier.isShowRelativeIntensity();
        this.getTitle().setForeground(this.getBackground());
        if (showMilliseconds) {
            this.getTitle().setText("");
            this.getTitle().setVisible(false);
        } else {
            this.getTitle().setText("Series");
            this.getTitle().setVisible(true);
        }
        this.xAxisTop.getTitle().setVisible(showMilliseconds);
        this.xAxisTop.getTick().setVisible(showMilliseconds);
        this.yAxisRight.getTitle().setVisible(showRelativeIntensity);
        this.yAxisRight.getTick().setVisible(showRelativeIntensity);
    }
}

