/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core;

import org.eclipse.chemclipse.chromatogram.msd.identifier.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.AbstractLibraryService;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.ILibraryService;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.ILibraryServiceProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.LibraryServiceProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.internal.identifier.FileIdentifier;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;

public class LibraryService
extends AbstractLibraryService
implements ILibraryService {
    private FileIdentifier fileIdentifier = new FileIdentifier();

    public ILibraryServiceProcessingInfo identify(IIdentificationTarget identificationTarget, IProgressMonitor monitor) {
        LibraryServiceProcessingInfo processingInfo = new LibraryServiceProcessingInfo();
        try {
            monitor.subTask("File Identifier - get reference mass spectrum");
            this.validateIdentificationTarget(identificationTarget);
            IMassSpectra massSpectra = this.fileIdentifier.getMassSpectra(identificationTarget, monitor);
            processingInfo.setMassSpectra(massSpectra);
        }
        catch (ValueMustNotBeNullException valueMustNotBeNullException) {
            processingInfo.addErrorMessage("File Identifier", "The identification target is not available.");
        }
        return processingInfo;
    }
}

