/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.AbstractMassSpectrumIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.IMassSpectraIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.MassSpectraIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IMassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.internal.identifier.FileIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.IVendorMassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectrumIdentifier
extends AbstractMassSpectrumIdentifier {
    public IMassSpectraIdentifierProcessingInfo identify(List<IScanMSD> massSpectraList, IMassSpectrumIdentifierSettings massSpectrumIdentifierSettings, IProgressMonitor monitor) {
        MassSpectraIdentifierProcessingInfo processingInfo = new MassSpectraIdentifierProcessingInfo();
        try {
            FileIdentifier fileIdentifier = new FileIdentifier();
            IVendorMassSpectrumIdentifierSettings fileIdentifierSettings = massSpectrumIdentifierSettings instanceof IVendorMassSpectrumIdentifierSettings ? (IVendorMassSpectrumIdentifierSettings)massSpectrumIdentifierSettings : PreferenceSupplier.getMassSpectrumIdentifierSettings();
            IMassSpectra massSpectra = fileIdentifier.runIdentification(massSpectraList, fileIdentifierSettings, monitor);
            processingInfo.setMassSpectra(massSpectra);
            processingInfo.addInfoMessage("File Identifier", "Mass spectra have been identified.");
        }
        catch (Exception exception) {
            processingInfo.addErrorMessage("File Identifier", "Something has gone wrong.");
        }
        return processingInfo;
    }

    public IMassSpectraIdentifierProcessingInfo identify(IScanMSD massSpectrum, IMassSpectrumIdentifierSettings massSpectrumIdentifierSettings, IProgressMonitor monitor) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        massSpectra.add(massSpectrum);
        return this.identify(massSpectra, massSpectrumIdentifierSettings, monitor);
    }

    public IMassSpectraIdentifierProcessingInfo identify(IScanMSD massSpectrum, IProgressMonitor monitor) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        massSpectra.add(massSpectrum);
        IVendorMassSpectrumIdentifierSettings massSpectrumIdentifierSettings = PreferenceSupplier.getMassSpectrumIdentifierSettings();
        return this.identify(massSpectra, (IMassSpectrumIdentifierSettings)massSpectrumIdentifierSettings, monitor);
    }

    public IMassSpectraIdentifierProcessingInfo identify(List<IScanMSD> massSpectra, IProgressMonitor monitor) {
        IVendorMassSpectrumIdentifierSettings massSpectrumIdentifierSettings = PreferenceSupplier.getMassSpectrumIdentifierSettings();
        return this.identify(massSpectra, (IMassSpectrumIdentifierSettings)massSpectrumIdentifierSettings, monitor);
    }
}

