/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.msd.model.notifier.IChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.ScanMassSpectrumUI;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScanMassSpectrumCycleNumberCombinedUIWithLabel
extends Composite
implements IChromatogramSelectionMSDUpdateNotifier {
    private ScanMassSpectrumUI massSpectrumUI;
    private Label label;
    private IScanMSD massSpectrum;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0##");
    private MassValueDisplayPrecision massValueDisplayPrecision;

    public ScanMassSpectrumCycleNumberCombinedUIWithLabel(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision) {
        super(parent, style);
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        composite.setLayout((Layout)new GridLayout(1, true));
        Composite labelbar = new Composite(composite, 4);
        labelbar.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        labelbar.setLayoutData((Object)gridData);
        this.label = new Label(labelbar, 0);
        this.label.setText("");
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.label.setLayoutData((Object)gridData);
        this.massSpectrumUI = new ScanMassSpectrumUI(composite, 2052, this.massValueDisplayPrecision);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.massSpectrumUI.setLayoutData(gridData);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (chromatogramSelection != null && this.massSpectrum != chromatogramSelection.getSelectedScan()) {
            IVendorMassSpectrum massSpectrum = chromatogramSelection.getSelectedScan();
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            if (chromatogram != null && massSpectrum != null) {
                int cycleNumber = massSpectrum.getCycleNumber();
                if (cycleNumber > 1) {
                    List scans = chromatogram.getScanCycleScans(cycleNumber);
                    ScanMSD massSpectrumCycleNumber = new ScanMSD();
                    for (IScan scan : scans) {
                        if (!(scan instanceof IScanMSD)) continue;
                        IScanMSD scanMSD = (IScanMSD)scan;
                        List ions = scanMSD.getIons();
                        for (IIon ion : ions) {
                            massSpectrumCycleNumber.addIon(ion, false);
                        }
                    }
                    this.setMassSpectrumLabel((IScanMSD)massSpectrumCycleNumber, scans.size());
                    this.massSpectrumUI.update((IScanMSD)massSpectrumCycleNumber, forceReload);
                } else {
                    this.setMassSpectrumLabel((IScanMSD)massSpectrum, 1);
                    this.massSpectrumUI.update((IScanMSD)massSpectrum, forceReload);
                }
            }
        }
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum, int sizeCycleNumberScans) {
        StringBuilder builder = new StringBuilder();
        builder.append("Cycle Number: ");
        builder.append(massSpectrum.getCycleNumber());
        builder.append(" | ");
        builder.append("Scan: ");
        builder.append(massSpectrum.getScanNumber());
        builder.append(" | ");
        builder.append("RT: ");
        builder.append(this.decimalFormat.format((double)massSpectrum.getRetentionTime() / 60000.0));
        builder.append(" | ");
        builder.append("Signal: ");
        builder.append(this.decimalFormat.format(massSpectrum.getTotalSignal()));
        builder.append(" | ");
        builder.append("Time Segment Id: ");
        builder.append(massSpectrum.getTimeSegmentId());
        builder.append(" | ");
        builder.append("Cyle Number Scans (");
        builder.append(sizeCycleNumberScans);
        builder.append(")");
        this.label.setText(builder.toString());
    }
}

