/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import org.eclipse.chemclipse.msd.model.core.AbstractScanMSD;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;

public abstract class AbstractRegularMassSpectrum
extends AbstractScanMSD
implements IRegularMassSpectrum {
    private static final long serialVersionUID = 6001414280468244074L;
    private short massSpectrometer;
    private short massSpectrumType;
    private double precursorIon;

    public AbstractRegularMassSpectrum() {
        this.massSpectrometer = 1;
        this.massSpectrumType = 0;
    }

    public AbstractRegularMassSpectrum(IScanMSD templateScan) {
        super(templateScan);
        if (templateScan instanceof IRegularMassSpectrum) {
            IRegularMassSpectrum regularMassSpectrum = (IRegularMassSpectrum)templateScan;
            this.massSpectrometer = regularMassSpectrum.getMassSpectrometer();
            this.massSpectrumType = regularMassSpectrum.getMassSpectrumType();
            this.precursorIon = regularMassSpectrum.getPrecursorIon();
        }
    }

    public AbstractRegularMassSpectrum(short massSpectrometer, short massSpectrumType) {
        this();
        this.setMassSpectrometer(massSpectrometer);
        this.setMassSpectrumType(massSpectrumType);
    }

    @Override
    public IExtractedIonSignal getExtractedIonSignal() {
        IExtractedIonSignal extractedIonSignal = super.getExtractedIonSignal();
        extractedIonSignal.setRetentionTime(this.getRetentionTime());
        extractedIonSignal.setRetentionIndex(this.getRetentionIndex());
        return extractedIonSignal;
    }

    @Override
    public IExtractedIonSignal getExtractedIonSignal(double startIon, double stopIon) {
        IExtractedIonSignal extractedIonSignal = super.getExtractedIonSignal(startIon, stopIon);
        extractedIonSignal.setRetentionTime(this.getRetentionTime());
        extractedIonSignal.setRetentionIndex(this.getRetentionIndex());
        return extractedIonSignal;
    }

    @Override
    public short getMassSpectrometer() {
        return this.massSpectrometer;
    }

    @Override
    public void setMassSpectrometer(short massSpectrometer) {
        this.massSpectrometer = massSpectrometer;
    }

    @Override
    public short getMassSpectrumType() {
        return this.massSpectrumType;
    }

    @Override
    public String getMassSpectrumTypeDescription() {
        String massSpectrumTypeDescription;
        switch (this.massSpectrumType) {
            case 0: {
                massSpectrumTypeDescription = "Centroid";
                break;
            }
            case 1: {
                massSpectrumTypeDescription = "Profile";
                break;
            }
            default: {
                massSpectrumTypeDescription = "Unknown";
            }
        }
        return massSpectrumTypeDescription;
    }

    @Override
    public void setMassSpectrumType(short massSpectrumType) {
        this.massSpectrumType = massSpectrumType;
    }

    @Override
    public double getPrecursorIon() {
        return this.precursorIon;
    }

    @Override
    public AbstractRegularMassSpectrum setPrecursorIon(double precursorIon) {
        this.precursorIon = precursorIon;
        return this;
    }
}

