/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.explorer;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.chemclipse.support.ui.wizards.TreeViewerFilesystemSupport;
import org.eclipse.chemclipse.ux.extension.ui.provider.ChromatogramFileExplorerContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.provider.ChromatogramFileExplorerLabelProvider;
import org.eclipse.chemclipse.ux.extension.ui.provider.ExplorerListSupport;
import org.eclipse.chemclipse.ux.extension.ui.provider.IChromatogramEditorSupport;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractChromatogramFileExplorer {
    private File lastClickedFile;
    private TreeViewer treeViewer;
    @Inject
    private EPartService partService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;

    public AbstractChromatogramFileExplorer(Composite parent, IChromatogramEditorSupport chromatogramEditorSupport) {
        this(parent, ExplorerListSupport.getChromatogramEditorSupportList(chromatogramEditorSupport));
    }

    public AbstractChromatogramFileExplorer(Composite parent, final List<IChromatogramEditorSupport> chromatogramEditorSupportList) {
        this.treeViewer = new TreeViewer(parent, 0x10000000);
        this.treeViewer.setContentProvider((IContentProvider)new ChromatogramFileExplorerContentProvider(chromatogramEditorSupportList));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ChromatogramFileExplorerLabelProvider(chromatogramEditorSupportList));
        TreeViewerFilesystemSupport.retrieveAndSetLocalFileSystem((TreeViewer)this.treeViewer);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (firstElement != null) {
                    File file = (File)firstElement;
                    if (file.isDirectory()) {
                        AbstractChromatogramFileExplorer.this.treeViewer.refresh(firstElement);
                    }
                    if (AbstractChromatogramFileExplorer.this.isNewFile(file)) {
                        for (IChromatogramEditorSupport chromatogramEditorSupport : chromatogramEditorSupportList) {
                            if (!chromatogramEditorSupport.isMatchMagicNumber(file)) continue;
                            chromatogramEditorSupport.openOverview(file, AbstractChromatogramFileExplorer.this.eventBroker);
                            break;
                        }
                    }
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                File file = (File)((IStructuredSelection)event.getSelection()).getFirstElement();
                for (IChromatogramEditorSupport chromatogramEditorSupport : chromatogramEditorSupportList) {
                    if (!chromatogramEditorSupport.isMatchMagicNumber(file)) continue;
                    chromatogramEditorSupport.openEditor(file, AbstractChromatogramFileExplorer.this.modelService, AbstractChromatogramFileExplorer.this.application, AbstractChromatogramFileExplorer.this.partService);
                }
            }
        });
    }

    @Focus
    private void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    private boolean isNewFile(File file) {
        if (this.lastClickedFile == null || this.lastClickedFile != file) {
            this.lastClickedFile = file;
            return true;
        }
        return false;
    }
}

