/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.util.List;
import org.eclipse.chemclipse.model.baseline.IChromatogramBaseline;
import org.eclipse.chemclipse.model.core.IChromatogramIntegrationSupport;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IChromatogramProcessorSupport;
import org.eclipse.chemclipse.model.core.IChromatogramResultSupport;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.updates.IUpdater;
import org.eclipse.chemclipse.model.versioning.IChromatogramVersioning;
import org.eclipse.chemclipse.support.history.ISupplierEditHistory;
import org.eclipse.core.runtime.IAdaptable;

public interface IChromatogram
extends IChromatogramOverview,
IAdaptable,
IChromatogramVersioning,
ISupplierEditHistory,
IChromatogramBaseline,
IUpdater,
IChromatogramResultSupport,
IChromatogramIntegrationSupport,
IChromatogramProcessorSupport {
    public static final String DEFAULT_CHROMATOGRAM_NAME = "Chromatogram";
    public static final int MIN_SCANDELAY = 0;
    public static final int MAX_SCANDELAY = 216000000;
    public static final int MIN_SCANINTERVAL = 1;
    public static final int MAX_SCANINTERVAL = 3600000;
    public static final float MIN_SCANS_PER_SECOND = 0.1f;
    public static final float MAX_SCANS_PER_SECOND = 20.0f;

    public void setConverterId(String var1);

    public String getConverterId();

    public void addScan(IScan var1);

    public IScan getScan(int var1);

    public List<IScan> getScans();

    public void removeScan(int var1);

    public void removeScans(int var1, int var2);

    public void recalculateTheNoiseFactor();

    public float getSignalToNoiseRatio(float var1);

    public String extractNameFromDirectory(String var1, String var2);

    public String extractNameFromFile(String var1);

    public List<IChromatogram> getReferencedChromatograms();

    public void addReferencedChromatogram(IChromatogram var1);

    public void removeReferencedChromatogram(IChromatogram var1);

    public void removeAllPeaks();

    public int getNumberOfPeaks();

    public void removeAllTargets();

    public void setUnloaded();

    public boolean isUnloaded();

    public boolean containsScanCycles();

    public List<IScan> getScanCycleScans(int var1);

    public IMethod getMethod();
}

