/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.signals;

import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignalExtractor;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignal;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;

public class TotalScanSignalExtractor
implements ITotalScanSignalExtractor {
    private IChromatogram chromatogram;

    public TotalScanSignalExtractor(IChromatogram chromatogram) throws ChromatogramIsNullException {
        if (chromatogram == null) {
            throw new ChromatogramIsNullException();
        }
        this.chromatogram = chromatogram;
    }

    public TotalScanSignalExtractor(IChromatogramOverview chromatogramOverview) throws ChromatogramIsNullException {
        if (chromatogramOverview == null) {
            throw new ChromatogramIsNullException();
        }
        if (!(chromatogramOverview instanceof IChromatogram)) {
            throw new ChromatogramIsNullException("Chromatogram Overview can't be casted to IChromatogram.");
        }
        this.chromatogram = (IChromatogram)chromatogramOverview;
    }

    @Override
    public ITotalScanSignals getTotalScanSignals() {
        return this.getTotalScanSignals(true);
    }

    @Override
    public ITotalScanSignals getTotalScanSignals(boolean validatePositive) {
        TotalScanSignals signals = new TotalScanSignals(this.chromatogram.getNumberOfScans(), this.chromatogram);
        for (IScan scan : this.chromatogram.getScans()) {
            TotalScanSignal totalScanSignal = new TotalScanSignal(scan.getRetentionTime(), scan.getRetentionIndex(), scan.getTotalSignal(), validatePositive);
            signals.add(totalScanSignal);
        }
        return signals;
    }

    @Override
    public ITotalScanSignals getTotalScanSignals(int startScan, int stopScan) {
        return this.getTotalScanSignals(startScan, stopScan, true);
    }

    @Override
    public ITotalScanSignals getTotalScanSignals(int startScan, int stopScan, boolean validatePositive) {
        return this.getTotalScanSignals(startScan, stopScan, validatePositive, false);
    }

    @Override
    public ITotalScanSignals getTotalScanSignals(int startScan, int stopScan, boolean validatePositive, boolean condenseCycleNumberScans) {
        TotalScanSignals totalScanSignals;
        if (startScan > stopScan) {
            int tmp = startScan;
            startScan = stopScan;
            stopScan = tmp;
        }
        if (startScan < 1 || startScan > this.chromatogram.getNumberOfScans() || stopScan < 1 || stopScan > this.chromatogram.getNumberOfScans()) {
            return new TotalScanSignals(0, this.chromatogram);
        }
        if (condenseCycleNumberScans) {
            totalScanSignals = new TotalScanSignals(startScan, stopScan);
            int scanNumber = startScan;
            while (scanNumber <= stopScan) {
                IScan scan = this.chromatogram.getScan(scanNumber);
                if (scan != null) {
                    int cycleNumber = scan.getCycleNumber();
                    boolean readScansOfCycleNumber = true;
                    float totalSignal = scan.getTotalSignal();
                    while (readScansOfCycleNumber) {
                        IScan scanNext;
                        if ((scanNext = this.chromatogram.getScan(++scanNumber)) != null) {
                            if (scanNext.getCycleNumber() == cycleNumber) {
                                totalSignal += scanNext.getTotalSignal();
                                continue;
                            }
                            --scanNumber;
                            readScansOfCycleNumber = false;
                            continue;
                        }
                        readScansOfCycleNumber = false;
                    }
                    TotalScanSignal totalScanSignal = new TotalScanSignal(scan.getRetentionTime(), scan.getRetentionIndex(), totalSignal, validatePositive);
                    totalScanSignals.add(totalScanSignal);
                }
                ++scanNumber;
            }
        } else {
            totalScanSignals = new TotalScanSignals(startScan, stopScan, this.chromatogram);
            int scan = startScan;
            while (scan <= stopScan) {
                IScan selectedScan = this.chromatogram.getScan(scan);
                TotalScanSignal totalScanSignal = new TotalScanSignal(selectedScan.getRetentionTime(), selectedScan.getRetentionIndex(), selectedScan.getTotalSignal(), validatePositive);
                totalScanSignals.add(totalScanSignal);
                ++scan;
            }
        }
        return totalScanSignals;
    }

    @Override
    public ITotalScanSignals getTotalScanSignals(IChromatogramSelection chromatogramSelection) {
        return this.getTotalScanSignals(chromatogramSelection, true);
    }

    @Override
    public ITotalScanSignals getTotalScanSignals(IChromatogram chromatogram, boolean validatePositive, boolean condenseCycleNumberScans) {
        if (chromatogram == null) {
            return new TotalScanSignals(0, chromatogram);
        }
        int startScan = chromatogram.getScanNumber(chromatogram.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogram.getStopRetentionTime());
        return this.getTotalScanSignals(startScan, stopScan, validatePositive, condenseCycleNumberScans);
    }

    @Override
    public ITotalScanSignals getTotalScanSignals(IChromatogramSelection chromatogramSelection, boolean validatePositive) {
        return this.getTotalScanSignals(chromatogramSelection, validatePositive, false);
    }

    @Override
    public ITotalScanSignals getTotalScanSignals(IChromatogramSelection chromatogramSelection, boolean validatePositive, boolean condenseCycleNumberScans) {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() != this.chromatogram) {
            return new TotalScanSignals(0, this.chromatogram);
        }
        int startScan = this.chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = this.chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        if (condenseCycleNumberScans) {
            return this.getTotalScanSignals(startScan, stopScan, validatePositive, true);
        }
        return this.getTotalScanSignals(startScan, stopScan, validatePositive, false);
    }
}

