/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.impl.StreamBasedParserBase;
import org.codehaus.jackson.io.IOContext;

public abstract class Utf8NumericParser
extends StreamBasedParserBase {
    public Utf8NumericParser(IOContext pc, int features, InputStream in, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(pc, features, in, inputBuffer, start, end, bufferRecyclable);
    }

    protected final JsonToken parseNumberText(int c) throws IOException, JsonParseException {
        boolean negative;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        boolean bl = negative = c == 45;
        if (negative) {
            outBuf[outPtr++] = 45;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            c = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        int intLen = 0;
        boolean eof = false;
        while (c >= 48 && c <= 57) {
            if (++intLen == 2 && outBuf[outPtr - 1] == '0') {
                this.reportInvalidNumber("Leading zeroes not allowed");
            }
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = (char)c;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                c = 0;
                eof = true;
                break;
            }
            c = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (intLen == 0) {
            this.reportInvalidNumber("Missing integer part (next char " + Utf8NumericParser._getCharDesc(c) + ")");
        }
        int fractLen = 0;
        if (c == 46) {
            outBuf[outPtr++] = (char)c;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    eof = true;
                    break;
                }
                if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || c > 57) break;
                ++fractLen;
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outBuf[outPtr++] = (char)c;
            }
            if (fractLen == 0) {
                this.reportUnexpectedNumberChar(c, "Decimal point not followed by a digit");
            }
        }
        int expLen = 0;
        if (c == 101 || c == 69) {
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = (char)c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) == 45 || c == 43) {
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outBuf[outPtr++] = (char)c;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                c = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            while (c <= 57 && c >= 48) {
                ++expLen;
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outBuf[outPtr++] = (char)c;
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    eof = true;
                    break;
                }
                c = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            if (expLen == 0) {
                this.reportUnexpectedNumberChar(c, "Exponent indicator not followed by a digit");
            }
        }
        if (!eof) {
            --this._inputPtr;
        }
        this._textBuffer.setCurrentLength(outPtr);
        return this.reset(negative, intLen, fractLen, expLen);
    }
}

