/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.ui.support;

import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.parts.ProcessingInfoPart;
import org.eclipse.chemclipse.processing.ui.support.DynamicProcessingInfoUpdateNotifier;
import org.eclipse.chemclipse.support.ui.addons.PerspectivePartSwitcherAddon;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class ProcessingInfoViewSupport {
    private static final String TITLE = "An error/some errors occured.";
    private static final String MESSAGE = "Please check the 'Feedback' view.";
    private static DynamicProcessingInfoUpdateNotifier dynamicUpdateNotifier;

    private ProcessingInfoViewSupport() {
    }

    public static void updateProcessingInfo(final IProcessingInfo processingInfo, final boolean focusProcessingInfoView) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell;
                if (processingInfo != null && processingInfo.hasErrorMessages() && (shell = Display.getCurrent().getActiveShell()) != null) {
                    MessageBox messageBox = new MessageBox(shell, 8);
                    messageBox.setText(ProcessingInfoViewSupport.TITLE);
                    messageBox.setMessage(ProcessingInfoViewSupport.MESSAGE);
                    messageBox.open();
                }
                ProcessingInfoViewSupport.updateProcessingInfoView(processingInfo);
                if (focusProcessingInfoView) {
                    PerspectivePartSwitcherAddon.focusPart((String)ProcessingInfoPart.ID);
                }
            }
        });
    }

    private static void updateProcessingInfoView(IProcessingInfo processingInfo) {
        if (dynamicUpdateNotifier == null) {
            Bundle bundle = FrameworkUtil.getBundle(ProcessingInfoViewSupport.class);
            BundleContext bundleContext = bundle.getBundleContext();
            IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            eclipseContext.set(Logger.class, null);
            dynamicUpdateNotifier = (DynamicProcessingInfoUpdateNotifier)ContextInjectionFactory.make(DynamicProcessingInfoUpdateNotifier.class, (IEclipseContext)eclipseContext);
        }
        dynamicUpdateNotifier.update(processingInfo);
    }
}

