/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculatorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.noise.INoiseCalculatorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.exceptions.NoNoiseCalculatorAvailableException;

public class NoiseCalculatorSupport
implements INoiseCalculatorSupport {
    private List<INoiseCalculatorSupplier> suppliers = new ArrayList<INoiseCalculatorSupplier>();

    protected void add(INoiseCalculatorSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailableCalculatorIds() throws NoNoiseCalculatorAvailableException {
        this.areCalculatorsStored();
        ArrayList<String> availableDetectors = new ArrayList<String>();
        for (INoiseCalculatorSupplier supplier : this.suppliers) {
            availableDetectors.add(supplier.getId());
        }
        return availableDetectors;
    }

    @Override
    public INoiseCalculatorSupplier getCalculatorSupplier(String calculatorId) throws NoNoiseCalculatorAvailableException {
        INoiseCalculatorSupplier detectorSupplier = null;
        this.areCalculatorsStored();
        if (calculatorId == null || calculatorId.equals("")) {
            throw new NoNoiseCalculatorAvailableException("There is no noise calculator available with the following id: " + calculatorId + ".");
        }
        for (INoiseCalculatorSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(calculatorId)) continue;
            detectorSupplier = supplier;
            break;
        }
        if (detectorSupplier == null) {
            throw new NoNoiseCalculatorAvailableException("There is no noise calculator available with the following id: " + calculatorId + ".");
        }
        return detectorSupplier;
    }

    @Override
    public String getCalculatorId(int index) throws NoNoiseCalculatorAvailableException {
        this.areCalculatorsStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoNoiseCalculatorAvailableException("There is no noise calculator available with the following id: " + index + ".");
        }
        INoiseCalculatorSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getCalculatorNames() throws NoNoiseCalculatorAvailableException {
        this.areCalculatorsStored();
        ArrayList<String> detectorNames = new ArrayList<String>();
        for (INoiseCalculatorSupplier supplier : this.suppliers) {
            detectorNames.add(supplier.getCalculatorName());
        }
        return detectorNames.toArray(new String[detectorNames.size()]);
    }

    private void areCalculatorsStored() throws NoNoiseCalculatorAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoNoiseCalculatorAvailableException();
        }
    }
}

