/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.model.core.comparator;

import java.util.Comparator;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.model.comparator.SortOrder;

public class ChromatogramPeakCSDComparator
implements Comparator<IChromatogramPeakCSD> {
    private SortOrder sortOrder;

    public ChromatogramPeakCSDComparator() {
        this.sortOrder = SortOrder.ASC;
    }

    public ChromatogramPeakCSDComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    @Override
    public int compare(IChromatogramPeakCSD peak1, IChromatogramPeakCSD peak2) {
        int returnValue;
        int retentionTime1 = peak1.getPeakModel().getRetentionTimeAtPeakMaximum();
        int retentionTime2 = peak2.getPeakModel().getRetentionTimeAtPeakMaximum();
        switch (this.sortOrder) {
            case ASC: {
                returnValue = Integer.compare(retentionTime1, retentionTime2);
                break;
            }
            case DESC: {
                returnValue = Integer.compare(retentionTime2, retentionTime1);
                break;
            }
            default: {
                returnValue = Integer.compare(retentionTime1, retentionTime2);
            }
        }
        return returnValue;
    }
}

