/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;

public class JacobianFunction
implements MultivariateMatrixFunction {
    private final MultivariateDifferentiableVectorFunction f;

    public JacobianFunction(MultivariateDifferentiableVectorFunction f) {
        this.f = f;
    }

    @Override
    public double[][] value(double[] point) {
        DerivativeStructure[] dsX = new DerivativeStructure[point.length];
        int i = 0;
        while (i < point.length) {
            dsX[i] = new DerivativeStructure(point.length, 1, i, point[i]);
            ++i;
        }
        DerivativeStructure[] dsY = this.f.value(dsX);
        double[][] y = new double[dsY.length][point.length];
        int[] orders = new int[point.length];
        int i2 = 0;
        while (i2 < dsY.length) {
            int j = 0;
            while (j < point.length) {
                orders[j] = 1;
                y[i2][j] = dsY[i2].getPartialDerivative(orders);
                orders[j] = 0;
                ++j;
            }
            ++i2;
        }
        return y;
    }
}

