/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.alignment.converter.exceptions.NoRetentionIndicesConverterAvailableException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices.IRetentionIndicesConverterSupport;
import org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices.IRetentionIndicesSupplier;

public class RetentionIndicesConverterSupport
implements IRetentionIndicesConverterSupport {
    private List<IRetentionIndicesSupplier> suppliers = new ArrayList<IRetentionIndicesSupplier>();

    protected void add(IRetentionIndicesSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public String getConverterId(int index) throws NoRetentionIndicesConverterAvailableException {
        this.areConvertersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoRetentionIndicesConverterAvailableException("The index: " + index + " is out of range.");
        }
        IRetentionIndicesSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getFilterExtensions() throws NoRetentionIndicesConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> extensions = new ArrayList<String>();
        for (IRetentionIndicesSupplier supplier : this.suppliers) {
            String extension = supplier.getFileExtension();
            extensions.add(extension);
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    @Override
    public String[] getFilterNames() throws NoRetentionIndicesConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (IRetentionIndicesSupplier supplier : this.suppliers) {
            filterNames.add(supplier.getFilterName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public List<String> getAvailableConverterIds(File retentionIndices) throws NoRetentionIndicesConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> availableConverters = new ArrayList<String>();
        for (IRetentionIndicesSupplier supplier : this.suppliers) {
            if (!retentionIndices.getName().endsWith(supplier.getFileExtension())) continue;
            availableConverters.add(supplier.getId());
        }
        if (availableConverters.isEmpty()) {
            throw new NoRetentionIndicesConverterAvailableException("There is no converter for the chromatogram file " + retentionIndices + " available.");
        }
        return availableConverters;
    }

    private void areConvertersStored() throws NoRetentionIndicesConverterAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoRetentionIndicesConverterAvailableException();
        }
    }
}

