/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors;

import java.util.Map;
import javafx.embed.swt.FXCanvas;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResult;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IPcaResults;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.ISample;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.ui.editors.PcaEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ScorePlot3dPage {
    private PcaEditor pcaEditor;

    public ScorePlot3dPage(PcaEditor pcaEditor, TabFolder tabFolder, FormToolkit formToolkit) {
        this.pcaEditor = pcaEditor;
        this.initialize(tabFolder, formToolkit);
    }

    public void update() {
        IPcaResults pcaResults = this.pcaEditor.getPcaResults();
        for (Map.Entry entry : pcaResults.getPcaResultMap().entrySet()) {
            IPcaResult pcaResult = (IPcaResult)entry.getValue();
            double[] eigenSpace = pcaResult.getEigenSpace();
            String name = ((ISample)entry.getKey()).getName();
            double x = eigenSpace[0];
            double y = eigenSpace[1];
            double z = eigenSpace[2];
            System.out.println(String.valueOf(name) + " -> " + x + "," + y + "," + z);
        }
    }

    private void initialize(TabFolder tabFolder, FormToolkit formToolkit) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("3D View");
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        final Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)1808);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        FXCanvas fxCanvas = new FXCanvas(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                this.getScene().getWindow().sizeToScene();
                int width = (int)this.getScene().getWidth();
                int height = (int)this.getScene().getHeight();
                return new Point(width, height);
            }
        };
        Group group = new Group();
        final Button javafxButton = new Button("Curious?");
        javafxButton.setId("pcaButton");
        group.getChildren().add((Object)javafxButton);
        Scene scene = new Scene((Parent)group, (Paint)Color.rgb((int)parent.getBackground().getRed(), (int)parent.getBackground().getGreen(), (int)parent.getBackground().getBlue()));
        scene.getStylesheets().add((Object)"css/pca.css");
        fxCanvas.setScene(scene);
        javafxButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (javafxButton.getText().equals("Curious?")) {
                    javafxButton.setText("A 3D view will be available soon!");
                } else {
                    javafxButton.setText("Curious?");
                }
                parent.layout();
            }
        });
        tabItem.setControl((Control)composite);
    }
}

