/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.notifier.ChromatogramSelectionCSDUpdateNotifier;
import org.eclipse.chemclipse.csd.model.notifier.IChromatogramSelectionCSDUpdateNotifier;
import org.eclipse.chemclipse.csd.swt.ui.components.chromatogram.EditorChromatogramUI;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.ux.extension.csd.ui.editors.IChromatogramEditorCSD;
import org.eclipse.chemclipse.ux.extension.csd.ui.internal.support.ChromatogramImportRunnable;
import org.eclipse.chemclipse.ux.extension.csd.ui.support.ChromatogramFileSupport;
import org.eclipse.chemclipse.ux.extension.csd.ui.support.ChromatogramSupport;
import org.eclipse.chemclipse.ux.extension.ui.dialogs.ReferencedChromatogramDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ChromatogramEditorCSD
implements IChromatogramEditorCSD,
IChromatogramSelectionCSDUpdateNotifier {
    public static final String ID = "org.eclipse.chemclipse.ux.extension.csd.ui.part.chromatogramEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.csd.ui/org.eclipse.chemclipse.ux.extension.csd.ui.editors.ChromatogramEditorCSD";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif";
    public static final String TOOLTIP = "Chromatogram - Detector Type: CSD";
    private static final Logger logger = Logger.getLogger(ChromatogramEditorCSD.class);
    @Inject
    private MPart part;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private IEventBroker eventBroker;
    private EventHandler eventHandler;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0##");
    private File chromatogramFile;
    private ChromatogramSelectionCSD chromatogramSelection;
    private EditorChromatogramUI chromatogramUI;
    private int chromatogramPageIndex;
    private int infoPageIndex;
    private int referencedChromatogramPageIndex;
    private TabFolder tabFolder;
    private Button buttonOverlay;
    private CLabel labelChromatogramRetentionTimeRange;
    private Text textStartRetentionTime;
    private Text textStopRetentionTime;
    private Button buttonLockOffset;
    private FormToolkit formToolkit;

    @PostConstruct
    private void createControl(Composite parent) {
        this.subscribe();
        this.loadChromatogram();
        this.createPages(parent);
        if (this.chromatogramSelection != null) {
            this.chromatogramSelection.update(true);
        }
    }

    @Focus
    public void setFocus() {
        if (this.tabFolder != null) {
            this.tabFolder.setFocus();
            if (this.tabFolder.getSelectionIndex() == this.chromatogramPageIndex && this.chromatogramSelection != null) {
                this.chromatogramSelection.update(false);
            }
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
        ChromatogramSelectionCSDUpdateNotifier.fireUpdateChange(null, (boolean)true);
        if (this.chromatogramSelection != null) {
            this.chromatogramSelection.dispose();
        }
        if (this.modelService != null) {
            MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            partStack.getChildren().remove(this.part);
        }
        if (this.formToolkit != null) {
            this.formToolkit.dispose();
        }
        System.gc();
    }

    @Persist
    public void save() {
        final Shell shell = Display.getDefault().getActiveShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Save Chromatogram", -1);
                    try {
                        ChromatogramEditorCSD.this.saveChromatogram(monitor, shell);
                    }
                    catch (NoChromatogramConverterAvailableException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.saveAs();
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
    }

    private void saveChromatogram(IProgressMonitor monitor, Shell shell) throws NoChromatogramConverterAvailableException {
        if (this.chromatogramSelection != null && shell != null) {
            IChromatogramCSD chromatogram = this.chromatogramSelection.getChromatogramCSD();
            String converterId = chromatogram.getConverterId();
            if (converterId != null && !converterId.equals("") && this.chromatogramFile != null) {
                monitor.subTask("Save Chromatogram");
                IChromatogramExportConverterProcessingInfo processingInfo = ChromatogramConverterCSD.convert((File)this.chromatogramFile, (IChromatogramCSD)chromatogram, (String)converterId, (IProgressMonitor)monitor);
                try {
                    processingInfo.getFile();
                    this.dirtyable.setDirty(false);
                }
                catch (TypeCastException typeCastException) {
                    throw new NoChromatogramConverterAvailableException();
                }
            } else {
                throw new NoChromatogramConverterAvailableException();
            }
        }
    }

    public boolean saveAs() {
        boolean saveSuccessful = false;
        if (this.chromatogramSelection != null) {
            try {
                saveSuccessful = ChromatogramFileSupport.saveChromatogram(this.chromatogramSelection.getChromatogramCSD());
                this.dirtyable.setDirty(!saveSuccessful);
            }
            catch (NoConverterAvailableException e) {
                logger.warn((Object)e);
            }
        }
        return saveSuccessful;
    }

    @Override
    public IChromatogramSelectionCSD getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public void update(IChromatogramSelectionCSD chromatogramSelection, boolean forceReload) {
        if (this.fireUpdate(chromatogramSelection, forceReload)) {
            int selectionIndex;
            if (forceReload) {
                this.dirtyable.setDirty(true);
            }
            if ((selectionIndex = this.tabFolder.getSelectionIndex()) == this.infoPageIndex) {
                this.updateInfoPageValues();
            }
            this.chromatogramUI.update(chromatogramSelection, forceReload);
        }
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    IChromatogramSelectionCSD selection = (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    ChromatogramEditorCSD.this.update(selection, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/csd/update/chromatogramselection", this.eventHandler);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    private void loadChromatogram() {
        try {
            Object object = this.part.getObject();
            if (object instanceof String) {
                File file = new File((String)object);
                this.importChromatogram(file);
            } else if (object instanceof IChromatogramCSD) {
                IChromatogramCSD chromatogram = (IChromatogramCSD)object;
                this.chromatogramSelection = new ChromatogramSelectionCSD((IChromatogram)chromatogram);
                this.chromatogramFile = null;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    private void importChromatogram(File file) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException, ChromatogramIsNullException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        ChromatogramImportRunnable runnable = new ChromatogramImportRunnable(file, this.chromatogramSelection);
        try {
            dialog.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        this.chromatogramSelection = runnable.getChromatogramSelection();
        this.chromatogramFile = file;
        int sizeReferencedChromatograms = this.chromatogramSelection.getChromatogramCSD().getReferencedChromatograms().size();
        if (sizeReferencedChromatograms > 0) {
            ReferencedChromatogramDialog referencedChromatogramDialog = new ReferencedChromatogramDialog(Display.getCurrent().getActiveShell(), this.chromatogramSelection.getChromatogram());
            referencedChromatogramDialog.create();
            if (referencedChromatogramDialog.open() == 0) {
                List selectedChromatograms = referencedChromatogramDialog.getSelectedChromatograms();
                for (IChromatogram chromatogram : selectedChromatograms) {
                    ChromatogramSupport.getInstanceEditorSupport().openEditor(chromatogram, this.modelService, this.application, this.partService);
                }
            }
        }
    }

    private void createPages(Composite parent) {
        if (this.chromatogramSelection != null && this.chromatogramSelection.getChromatogramCSD() != null) {
            this.part.setLabel(this.chromatogramSelection.getChromatogramCSD().getName());
            this.tabFolder = new TabFolder(parent, 1024);
            this.createChromatogramPage();
            this.chromatogramPageIndex = 0;
            this.createInfoPage();
            this.infoPageIndex = 1;
            this.createReferencedChromatogramPage();
            this.referencedChromatogramPageIndex = 2;
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ChromatogramEditorCSD.this.tabFolder.getSelectionIndex();
                    if (ChromatogramEditorCSD.this.chromatogramSelection != null) {
                        switch (index) {
                            case 0: {
                                ChromatogramEditorCSD.this.update((IChromatogramSelectionCSD)ChromatogramEditorCSD.this.chromatogramSelection, false);
                                break;
                            }
                            case 1: {
                                ChromatogramEditorCSD.this.updateInfoPageValues();
                                break;
                            }
                        }
                    }
                }
            });
        } else {
            this.createErrorMessagePage(parent);
        }
    }

    private void updateInfoPageValues() {
        if (this.buttonOverlay != null) {
            this.buttonOverlay.setSelection(this.chromatogramSelection.isOverlaySelected());
        }
        if (this.labelChromatogramRetentionTimeRange != null) {
            IChromatogramCSD chromatogram = this.chromatogramSelection.getChromatogramCSD();
            String minRetentionTime = this.decimalFormat.format((double)chromatogram.getStartRetentionTime() / 60000.0);
            String maxRetentionTime = this.decimalFormat.format((double)chromatogram.getStopRetentionTime() / 60000.0);
            this.labelChromatogramRetentionTimeRange.setText("Chromatogram (Minutes): " + minRetentionTime + " - " + maxRetentionTime);
        }
        if (this.textStartRetentionTime != null && this.textStopRetentionTime != null) {
            this.textStartRetentionTime.setText(this.decimalFormat.format((double)this.chromatogramSelection.getStartRetentionTime() / 60000.0));
            this.textStopRetentionTime.setText(this.decimalFormat.format((double)this.chromatogramSelection.getStopRetentionTime() / 60000.0));
        }
        if (this.buttonLockOffset != null) {
            this.buttonLockOffset.setSelection(this.chromatogramSelection.isLockOffset());
        }
    }

    private void createChromatogramPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Chromatogram");
        this.chromatogramUI = new EditorChromatogramUI((Composite)this.tabFolder, 0);
        this.chromatogramUI.setMaster(true);
        this.chromatogramUI.update((IChromatogramSelectionCSD)this.chromatogramSelection, true);
        tabItem.setControl((Control)this.chromatogramUI);
    }

    private void createErrorMessagePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatogram Editor");
        this.createProblemSection(scrolledFormComposite);
        this.createResolutionSection(scrolledFormComposite);
    }

    private void createProblemSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Problem");
        section.setDescription("There has gone something wrong to open the chromatogram.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        this.createLabel(client, "The chromatogram couldn't be loaded.", "warn.gif");
        this.createLabel(client, "Does the selected chromatogram contains data recorded by a flame ionization detector?", "question.gif");
        this.createLabel(client, "Is the data file corrupted?", "question.gif");
        this.createLabel(client, "Is an appropriate file format converter installed?", "question.gif");
        this.createLink(client, "Converters can be installed using the marketplace.", "https://marketplace.openchrom.net");
        this.createLabel(client, "Does the converter has a valid license? (Menu -> Window -> Preferences -> Converter)", "question.gif");
        this.createLink(client, "Create a log-in and retrieve free serial keys.", "https://marketplace.openchrom.net");
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void createResolutionSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Further Questions");
        section.setDescription("The developers may have a solution for you.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.createLabel(client, "MSD data is also supported.", "info.gif");
        this.createLink(client, "Please contact the developers, if you have further questions.", "https://www.openchrom.net");
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private CLabel createLabel(Composite parent, String text, String image) {
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        CLabel label = new CLabel(parent, 16384);
        label.setText(text);
        if (image != null) {
            label.setImage(ApplicationImageFactory.getInstance().getImage(image, "16x16"));
        }
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void createReferencedChromatogramHyperlink(Composite parent, int number, final IChromatogramCSD chromatogram) {
        ImageHyperlink imageHyperlink = new ImageHyperlink(parent, 16384);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("execute.gif", "16x16"));
        imageHyperlink.setText("Chromatogram #" + number);
        imageHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ChromatogramSupport.getInstanceEditorSupport().openOverview((IChromatogramOverview)chromatogram, ChromatogramEditorCSD.this.eventBroker);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                ChromatogramSupport.getInstanceEditorSupport().openEditor((IChromatogram)chromatogram, ChromatogramEditorCSD.this.modelService, ChromatogramEditorCSD.this.application, ChromatogramEditorCSD.this.partService);
            }
        });
    }

    private void createLink(Composite parent, String text, final String url) {
        Link link = new Link(parent, 0);
        link.setText(String.valueOf(text) + " (<a>" + url + "</a>)");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Program.launch((String)url);
            }
        });
    }

    private void createInfoPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Info");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatogram Info");
        this.createInfoPageSection(scrolledFormComposite);
        tabItem.setControl((Control)composite);
    }

    private void createInfoPageSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Chromatogram Selection");
        section.setDescription("Display of the current chromatogram selection.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        this.buttonOverlay = new Button(client, 32);
        this.buttonOverlay.setSelection(this.chromatogramSelection.isOverlaySelected());
        this.buttonOverlay.setText("Show chromatogram in overlay");
        this.buttonOverlay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean overlaySelected = ChromatogramEditorCSD.this.buttonOverlay.getSelection();
                ChromatogramEditorCSD.this.chromatogramSelection.setOverlaySelected(overlaySelected);
            }
        });
        this.labelChromatogramRetentionTimeRange = this.createLabel(client, "Retention Time Range (Chromatogram):", "info.gif");
        this.createLabel(client, "Start Retention Time (Minutes):", null);
        this.textStartRetentionTime = new Text(client, 0);
        this.textStartRetentionTime.setLayoutData((Object)new GridData(768));
        this.createLabel(client, "Stop Retention Time (Minutes):", null);
        this.textStopRetentionTime = new Text(client, 0);
        this.textStopRetentionTime.setLayoutData((Object)new GridData(768));
        Button button = new Button(client, 8);
        button.setText("Set Retention Time Range");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromatogramEditorCSD.this.setRetentionTimeRange();
            }
        });
        this.buttonLockOffset = new Button(client, 32);
        this.buttonLockOffset.setSelection(this.chromatogramSelection.isLockOffset());
        this.buttonLockOffset.setText("Lock Offset");
        this.buttonLockOffset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean lockOffset = ChromatogramEditorCSD.this.buttonLockOffset.getSelection();
                ChromatogramEditorCSD.this.chromatogramSelection.setLockOffset(lockOffset);
            }
        });
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void setRetentionTimeRange() {
        String startRetentionTimeText = this.textStartRetentionTime.getText().trim();
        String stopRetentionTimeText = this.textStopRetentionTime.getText().trim();
        try {
            int startRetentionTime = (int)(this.decimalFormat.parse(startRetentionTimeText).doubleValue() * 60000.0);
            int stopRetentionTime = (int)(this.decimalFormat.parse(stopRetentionTimeText).doubleValue() * 60000.0);
            if (startRetentionTime < stopRetentionTime) {
                this.chromatogramSelection.setStartRetentionTime(startRetentionTime);
                this.chromatogramSelection.setStopRetentionTime(stopRetentionTime);
                this.chromatogramUI.updateSelectionManually((IChromatogramSelection)this.chromatogramSelection);
                this.fireUpdate((IChromatogramSelectionCSD)this.chromatogramSelection, true);
            }
        }
        catch (ParseException e) {
            logger.warn((Object)e);
        }
    }

    private void createReferencedChromatogramPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Referenced Chromatograms");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatograms");
        this.createReferencedChromatogramPageSection(scrolledFormComposite);
        tabItem.setControl((Control)composite);
    }

    private void createReferencedChromatogramPageSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("References");
        section.setDescription("Display of the chromatogram references.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        List references = this.chromatogramSelection.getChromatogram().getReferencedChromatograms();
        int counter = 1;
        for (IChromatogram chromatogram : references) {
            if (!(chromatogram instanceof IChromatogramCSD)) continue;
            IChromatogramCSD chromatogramFID = (IChromatogramCSD)chromatogram;
            this.createReferencedChromatogramHyperlink(client, counter++, chromatogramFID);
        }
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private boolean fireUpdate(IChromatogramSelectionCSD chromatogramSelection, boolean forceReload) {
        if (this.chromatogramUI == null || chromatogramSelection == null || this.chromatogramSelection == null) {
            return false;
        }
        if (forceReload) {
            return this.chromatogramSelection.getChromatogramCSD() == chromatogramSelection.getChromatogramCSD();
        }
        return this.chromatogramSelection == chromatogramSelection;
    }
}

