/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class AnalysisProjectWizard
extends Wizard
implements INewWizard {
    private static final Logger logger = Logger.getLogger(AnalysisProjectWizard.class);
    private WizardNewProjectCreationPage projectCreationPage;

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    AnalysisProjectWizard.this.createProject((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.projectCreationPage = new WizardNewProjectCreationPage("MS Analysis Project");
        this.projectCreationPage.setTitle("New MS Analysis Project");
        this.projectCreationPage.setDescription("Create a new MS Analysis Project");
        this.addPage((IWizardPage)this.projectCreationPage);
    }

    protected void createProject(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Creating MS Analysis Project", 50);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            monitor.subTask("Create Directories");
            IProject project = workspaceRoot.getProject(this.projectCreationPage.getProjectName());
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            if (!Platform.getLocation().equals((Object)this.projectCreationPage.getLocationPath())) {
                projectDescription.setLocation(this.projectCreationPage.getLocationPath());
            }
            try {
                project.create(projectDescription, monitor);
                monitor.worked(10);
                project.open(monitor);
                IPath projectPath = project.getFullPath();
                IPath dataFiles = projectPath.append("DataFiles");
                IFolder dataFolder = workspaceRoot.getFolder(dataFiles);
                dataFolder.create(false, true, monitor);
                IPath reportFiles = projectPath.append("ReportFiles");
                IFolder reportFolder = workspaceRoot.getFolder(reportFiles);
                reportFolder.create(false, true, monitor);
                IPath report = reportFiles.append("analysisReport.txt");
                IFile reportFile = workspaceRoot.getFile(report);
                reportFile.create(null, false, monitor);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

