/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholder_D64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.SpecializedOps;

public class LinearSolverQrHouse_D64
extends LinearSolverAbstract_D64 {
    private QRDecompositionHouseholder_D64 decomposer = new QRDecompositionHouseholder_D64();
    private double[] a;
    private double[] u;
    private int maxRows = -1;
    private DenseMatrix64F QR;
    private double[] gammas;

    public void setMaxSize(int maxRows) {
        this.maxRows = maxRows;
        this.a = new double[maxRows];
        this.u = new double[maxRows];
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        if (A.numRows > this.maxRows) {
            this.setMaxSize(A.numRows);
        }
        this._setA(A);
        if (!this.decomposer.decompose(A)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        return true;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(this.QR);
    }

    @Override
    public void solve(DenseMatrix64F B, DenseMatrix64F X) {
        if (X.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X");
        }
        if (B.numRows != this.numRows || B.numCols != X.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int BnumCols = B.numCols;
        int colB = 0;
        while (colB < BnumCols) {
            int i = 0;
            while (i < this.numRows) {
                this.a[i] = B.data[i * BnumCols + colB];
                ++i;
            }
            int n = 0;
            while (n < this.numCols) {
                this.u[n] = 1.0;
                double ub = this.a[n];
                int i2 = n + 1;
                while (i2 < this.numRows) {
                    this.u[i2] = this.QR.unsafe_get(i2, n);
                    ub += this.u[i2] * this.a[i2];
                    ++i2;
                }
                ub *= this.gammas[n];
                i2 = n;
                while (i2 < this.numRows) {
                    int n2 = i2;
                    this.a[n2] = this.a[n2] - this.u[i2] * ub;
                    ++i2;
                }
                ++n;
            }
            TriangularSolver.solveU(this.QR.data, this.a, this.numCols);
            i = 0;
            while (i < this.numCols) {
                X.data[i * X.numCols + colB] = this.a[i];
                ++i;
            }
            ++colB;
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecomposition<DenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

