/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.RowD1Matrix64F;

public class MatrixMultProduct {
    public static void outer(RowD1Matrix64F a, RowD1Matrix64F c) {
        int i = 0;
        while (i < a.numRows) {
            int indexC1;
            int indexC2 = indexC1 = i * c.numCols + i;
            int j = i;
            while (j < a.numRows) {
                int indexA = i * a.numCols;
                int indexB = j * a.numCols;
                double sum = 0.0;
                int end = indexA + a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB];
                    ++indexA;
                    ++indexB;
                }
                int n = indexC1++;
                double d = sum;
                c.data[n] = d;
                c.data[indexC2] = d;
                ++j;
                indexC2 += c.numCols;
            }
            ++i;
        }
    }

    public static void inner_small(RowD1Matrix64F a, RowD1Matrix64F c) {
        int i = 0;
        while (i < a.numCols) {
            int j = i;
            while (j < a.numCols) {
                int indexC1 = i * c.numCols + j;
                int indexC2 = j * c.numCols + i;
                int indexA = i;
                int indexB = j;
                double sum = 0.0;
                int end = indexA + a.numRows * a.numCols;
                while (indexA < end) {
                    sum += a.data[indexA] * a.data[indexB];
                    indexA += a.numCols;
                    indexB += a.numCols;
                }
                c.data[indexC1] = c.data[indexC2] = sum;
                ++j;
            }
            ++i;
        }
    }

    public static void inner_reorder(RowD1Matrix64F a, RowD1Matrix64F c) {
        int i = 0;
        while (i < a.numCols) {
            int indexC = i * c.numCols + i;
            double valAi = a.data[i];
            int j = i;
            while (j < a.numCols) {
                c.data[indexC++] = valAi * a.data[j];
                ++j;
            }
            int k = 1;
            while (k < a.numRows) {
                indexC = i * c.numCols + i;
                int indexB = k * a.numCols + i;
                valAi = a.data[indexB];
                int j2 = i;
                while (j2 < a.numCols) {
                    int n = indexC++;
                    c.data[n] = c.data[n] + valAi * a.data[indexB++];
                    ++j2;
                }
                ++k;
            }
            int indexC2 = indexC = i * c.numCols + i;
            int j3 = i;
            while (j3 < a.numCols) {
                c.data[indexC2] = c.data[indexC++];
                ++j3;
                indexC2 += c.numCols;
            }
            ++i;
        }
    }

    public static void inner_reorder_upper(RowD1Matrix64F a, RowD1Matrix64F c) {
        int i = 0;
        while (i < a.numCols) {
            int indexC = i * c.numCols + i;
            double valAi = a.data[i];
            int j = i;
            while (j < a.numCols) {
                c.data[indexC++] = valAi * a.data[j];
                ++j;
            }
            int k = 1;
            while (k < a.numRows) {
                indexC = i * c.numCols + i;
                int indexB = k * a.numCols + i;
                valAi = a.data[indexB];
                int j2 = i;
                while (j2 < a.numCols) {
                    int n = indexC++;
                    c.data[n] = c.data[n] + valAi * a.data[indexB++];
                    ++j2;
                }
                ++k;
            }
            ++i;
        }
    }
}

