/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;

public class VectorVectorMult {
    public static double innerProd(D1Matrix64F x, D1Matrix64F y) {
        int m = x.getNumElements();
        double total = 0.0;
        int i = 0;
        while (i < m) {
            total += x.get(i) * y.get(i);
            ++i;
        }
        return total;
    }

    public static double innerProdA(D1Matrix64F x, D1Matrix64F A, D1Matrix64F y) {
        int n = A.numRows;
        int m = A.numCols;
        if (x.getNumElements() != n) {
            throw new IllegalArgumentException("Unexpected number of elements in x");
        }
        if (y.getNumElements() != m) {
            throw new IllegalArgumentException("Unexpected number of elements in y");
        }
        double result = 0.0;
        int i = 0;
        while (i < m) {
            double total = 0.0;
            int j = 0;
            while (j < n) {
                total += x.get(j) * A.unsafe_get(j, i);
                ++j;
            }
            result += total * y.get(i);
            ++i;
        }
        return result;
    }

    public static double innerProdTranA(D1Matrix64F x, D1Matrix64F A, D1Matrix64F y) {
        int n = A.numRows;
        if (n != A.numCols) {
            throw new IllegalArgumentException("A must be square");
        }
        if (x.getNumElements() != n) {
            throw new IllegalArgumentException("Unexpected number of elements in x");
        }
        if (y.getNumElements() != n) {
            throw new IllegalArgumentException("Unexpected number of elements in y");
        }
        double result = 0.0;
        int i = 0;
        while (i < n) {
            double total = 0.0;
            int j = 0;
            while (j < n) {
                total += x.get(j) * A.unsafe_get(i, j);
                ++j;
            }
            result += total * y.get(i);
            ++i;
        }
        return result;
    }

    public static void outerProd(D1Matrix64F x, D1Matrix64F y, RowD1Matrix64F A) {
        int m = A.numRows;
        int n = A.numCols;
        int index = 0;
        int i = 0;
        while (i < m) {
            double xdat = x.get(i);
            int j = 0;
            while (j < n) {
                A.set(index++, xdat * y.get(j));
                ++j;
            }
            ++i;
        }
    }

    public static void addOuterProd(double gamma, D1Matrix64F x, D1Matrix64F y, RowD1Matrix64F A) {
        int m = A.numRows;
        int n = A.numCols;
        int index = 0;
        if (gamma == 1.0) {
            int i = 0;
            while (i < m) {
                double xdat = x.get(i);
                int j = 0;
                while (j < n) {
                    A.plus(index++, xdat * y.get(j));
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < m) {
                double xdat = x.get(i);
                int j = 0;
                while (j < n) {
                    A.plus(index++, gamma * xdat * y.get(j));
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void householder(double gamma, D1Matrix64F u, D1Matrix64F x, D1Matrix64F y) {
        int n = u.getNumElements();
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            sum += u.get(i) * x.get(i);
            ++i;
        }
        i = 0;
        while (i < n) {
            y.set(i, x.get(i) + gamma * u.get(i) * sum);
            ++i;
        }
    }

    public static void rank1Update(double gamma, DenseMatrix64F A, DenseMatrix64F u, DenseMatrix64F w, DenseMatrix64F B) {
        int n = u.getNumElements();
        int matrixIndex = 0;
        int i = 0;
        while (i < n) {
            double elementU = u.data[i];
            int j = 0;
            while (j < n) {
                B.data[matrixIndex] = A.data[matrixIndex] + gamma * elementU * w.data[j];
                ++j;
                ++matrixIndex;
            }
            ++i;
        }
    }

    public static void rank1Update(double gamma, DenseMatrix64F A, DenseMatrix64F u, DenseMatrix64F w) {
        int n = u.getNumElements();
        int matrixIndex = 0;
        int i = 0;
        while (i < n) {
            double elementU = u.data[i];
            int j = 0;
            while (j < n) {
                int n2 = matrixIndex++;
                A.data[n2] = A.data[n2] + gamma * elementU * w.data[j];
                ++j;
            }
            ++i;
        }
    }
}

