/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.core;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.AbstractChromatogramIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.chromatogram.IChromatogramIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.ChromatogramIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.IChromatogramIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support.TrapezoidChromatogramIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramIntegrator
extends AbstractChromatogramIntegrator {
    private static final Logger logger = Logger.getLogger(ChromatogramIntegrator.class);

    public IChromatogramIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IChromatogramIntegrationSettings chromatogramIntegrationSettings, IProgressMonitor monitor) {
        ChromatogramIntegratorProcessingInfo processingInfo = new ChromatogramIntegratorProcessingInfo();
        try {
            super.validate(chromatogramSelection, chromatogramIntegrationSettings);
            TrapezoidChromatogramIntegratorSupport firstDerivativeChromatogramIntegratorSupport = new TrapezoidChromatogramIntegratorSupport();
            IChromatogramIntegrationResults chromatogramIntegrationResults = firstDerivativeChromatogramIntegratorSupport.calculateChromatogramIntegrationResults(chromatogramSelection, chromatogramIntegrationSettings, monitor);
            processingInfo.setChromatogramIntegrationResults(chromatogramIntegrationResults);
        }
        catch (ValueMustNotBeNullException e) {
            logger.warn((Object)e);
            this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    public IChromatogramIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        IChromatogramIntegrationSettings chromatogramIntegrationSettings = PreferenceSupplier.getChromatogramIntegrationSettings();
        return this.integrate(chromatogramSelection, chromatogramIntegrationSettings, monitor);
    }

    private void addIntegratorExceptionInfo(IProcessingInfo processingInfo) {
        processingInfo.addErrorMessage("Chromatogram Integrator Trapezoid", "The peak(s) or settings couldn't be validated correctly.");
    }
}

