/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.ChromatogramSelection;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.swt.ui.exceptions.NoPeaksAvailableException;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.series.MultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.Series;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.chemclipse.swt.ui.support.Sign;

public class SeriesConverter {
    public static final Logger logger = Logger.getLogger(SeriesConverter.class);

    private SeriesConverter() {
    }

    public static ISeries convertChromatogramOverview(IChromatogramOverview chromatogramOverview, Sign sign, boolean validatePositive) {
        ArrayList<IChromatogramOverview> chromatogramOverviews = new ArrayList<IChromatogramOverview>();
        chromatogramOverviews.add(chromatogramOverview);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries chromatogramSeries = SeriesConverter.convertChromatogramOverviews(chromatogramOverviews, sign, offset, validatePositive);
        return chromatogramSeries.getMultipleSeries().get(0);
    }

    public static IMultipleSeries convertChromatogramOverviews(List<IChromatogramOverview> chromatogramOverviews, Sign sign, IOffset offset, boolean validatePositive) {
        MultipleSeries chromatogramSeries = new MultipleSeries();
        if (chromatogramOverviews != null) {
            offset = SeriesConverter.validateOffset(offset);
            for (IChromatogramOverview chromatogramOverview : chromatogramOverviews) {
                try {
                    TotalScanSignalExtractor totalIonSignalExtractor = new TotalScanSignalExtractor(chromatogramOverview);
                    ITotalScanSignals signals = totalIonSignalExtractor.getTotalScanSignals(validatePositive);
                    int numberOfScans = signals.size();
                    double[] xSeries = new double[numberOfScans];
                    double[] ySeries = new double[numberOfScans];
                    int x = 0;
                    int y = 0;
                    for (ITotalScanSignal signal : signals.getTotalScanSignals()) {
                        double retentionTime = signal.getRetentionTime();
                        double abundance = signal.getTotalSignal();
                        double xOffset = offset.getCurrentXOffset();
                        double yOffset = offset.getCurrentYOffset();
                        if (sign == Sign.NEGATIVE) {
                            abundance *= -1.0;
                            xOffset *= -1.0;
                            yOffset *= -1.0;
                        }
                        xSeries[x++] = retentionTime += xOffset;
                        ySeries[y++] = abundance += yOffset;
                    }
                    offset.incrementCurrentXOffset();
                    offset.incrementCurrentYOffset();
                    chromatogramSeries.add(new Series(xSeries, ySeries, chromatogramOverview.getName()));
                }
                catch (ChromatogramIsNullException e) {
                    logger.warn((Object)e);
                }
            }
        }
        return chromatogramSeries;
    }

    public static IMultipleSeries convertChromatograms(List<IChromatogramSelection> chromatogramSelections, Sign sign, IOffset offset, boolean validatePositive) {
        return SeriesConverter.convertChromatograms(chromatogramSelections, sign, offset, false, validatePositive);
    }

    public static IMultipleSeries convertChromatograms(List<IChromatogramSelection> chromatogramSelections, Sign sign, IOffset offset, boolean useLockedOffset, boolean validatePositive) {
        MultipleSeries chromatogramSeries = new MultipleSeries();
        if (chromatogramSelections != null && chromatogramSelections.size() >= 1) {
            offset = SeriesConverter.validateOffset(offset);
            int masterStartRetentionTime = chromatogramSelections.get(0).getStartRetentionTime();
            int masterStopRetentionTime = chromatogramSelections.get(0).getStopRetentionTime();
            int counter = 0;
            for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
                ITotalScanSignals signals;
                boolean isLockOffset = false;
                if (useLockedOffset) {
                    isLockOffset = chromatogramSelection.isLockOffset();
                }
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                ++counter;
                int startScan = SeriesConverter.getStartScan(masterStartRetentionTime, chromatogram);
                int stopScan = SeriesConverter.getStopScan(masterStopRetentionTime, chromatogram);
                if (startScan == 0 || stopScan == 0 || (signals = SeriesConverter.getTotalScanSignals(chromatogram, startScan, stopScan, validatePositive)) == null) continue;
                int scans = SeriesConverter.getSizeWithRetentionTimeGreatherThanZero(signals);
                double[] xSeries = new double[scans];
                double[] ySeries = new double[scans];
                int x = 0;
                int y = 0;
                for (ITotalScanSignal signal : signals.getTotalScanSignals()) {
                    double yOffset;
                    double xOffset;
                    double retentionTime = signal.getRetentionTime();
                    double abundance = signal.getTotalSignal();
                    if (retentionTime == 0.0) continue;
                    if (isLockOffset) {
                        xOffset = chromatogramSelection.getOffset().getX();
                        yOffset = chromatogramSelection.getOffset().getY();
                    } else {
                        xOffset = offset.getCurrentXOffset();
                        yOffset = offset.getCurrentYOffset();
                    }
                    if (sign == Sign.NEGATIVE) {
                        abundance *= -1.0;
                        xOffset *= -1.0;
                        yOffset *= -1.0;
                    }
                    xSeries[x++] = retentionTime += xOffset;
                    ySeries[y++] = abundance += yOffset;
                }
                offset.incrementCurrentXOffset();
                offset.incrementCurrentYOffset();
                chromatogramSeries.add(new Series(xSeries, ySeries, "[" + counter + "] " + chromatogram.getName()));
            }
        }
        return chromatogramSeries;
    }

    public static IMultipleSeries convertChromatogramsMirrored(List<IChromatogramSelection> chromatogramSelections, IOffset offset, boolean validatePositive) {
        MultipleSeries chromatogramSeries = new MultipleSeries();
        if (chromatogramSelections != null && chromatogramSelections.size() >= 1) {
            offset = SeriesConverter.validateOffset(offset);
            int masterStartRetentionTime = chromatogramSelections.get(0).getStartRetentionTime();
            int masterStopRetentionTime = chromatogramSelections.get(0).getStopRetentionTime();
            int counter = 0;
            for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
                ITotalScanSignals signals;
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                ++counter;
                int startScan = SeriesConverter.getStartScan(masterStartRetentionTime, chromatogram);
                int stopScan = SeriesConverter.getStopScan(masterStopRetentionTime, chromatogram);
                if (startScan == 0 || stopScan == 0 || (signals = SeriesConverter.getTotalScanSignals(chromatogram, startScan, stopScan, validatePositive)) == null) continue;
                int scans = SeriesConverter.getSizeWithRetentionTimeGreatherThanZero(signals);
                double[] xSeries = new double[scans];
                double[] ySeries = new double[scans];
                int x = 0;
                int y = 0;
                for (ITotalScanSignal signal : signals.getTotalScanSignals()) {
                    double retentionTime = signal.getRetentionTime();
                    double abundance = signal.getTotalSignal();
                    if (retentionTime == 0.0) continue;
                    double xOffset = offset.getCurrentXOffset();
                    double yOffset = offset.getCurrentYOffset();
                    if (counter > 1) {
                        abundance *= -1.0;
                        xOffset *= -1.0;
                        yOffset *= -1.0;
                    }
                    xSeries[x++] = retentionTime += xOffset;
                    ySeries[y++] = abundance += yOffset;
                }
                offset.incrementCurrentXOffset();
                offset.incrementCurrentYOffset();
                chromatogramSeries.add(new Series(xSeries, ySeries, "[" + counter + "] " + chromatogram.getName()));
            }
        }
        return chromatogramSeries;
    }

    public static IMultipleSeries convertChromatogramsSubtracted(List<IChromatogramSelection> chromatogramSelections, IOffset offset, boolean validatePositive) {
        MultipleSeries chromatogramSeries = new MultipleSeries();
        if (chromatogramSelections != null && chromatogramSelections.size() >= 1) {
            offset = SeriesConverter.validateOffset(offset);
            IChromatogramSelection chromatogramSelectionMaster = chromatogramSelections.get(0);
            IChromatogram chromatogramMaster = chromatogramSelectionMaster.getChromatogram();
            int masterStartRetentionTime = chromatogramSelectionMaster.getStartRetentionTime();
            int masterStopRetentionTime = chromatogramSelectionMaster.getStopRetentionTime();
            int i = 1;
            while (i < chromatogramSelections.size()) {
                ITotalScanSignals signals;
                IChromatogramSelection chromatogramSelection = chromatogramSelections.get(i);
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                int startScan = SeriesConverter.getStartScan(masterStartRetentionTime, chromatogram);
                int stopScan = SeriesConverter.getStopScan(masterStopRetentionTime, chromatogram);
                if (startScan != 0 && stopScan != 0 && (signals = SeriesConverter.getTotalScanSignals(chromatogram, startScan, stopScan, validatePositive)) != null) {
                    int scans = SeriesConverter.getSizeWithRetentionTimeGreatherThanZero(signals);
                    double[] xSeries = new double[scans];
                    double[] ySeries = new double[scans];
                    int x = 0;
                    int y = 0;
                    int scan = startScan;
                    while (scan <= stopScan) {
                        int scanNumberMaster;
                        IScan scanMaster;
                        ITotalScanSignal signal = signals.getTotalScanSignal(scan);
                        double retentionTime = signal.getRetentionTime();
                        if (retentionTime != 0.0 && (scanMaster = chromatogramMaster.getScan(scanNumberMaster = chromatogramMaster.getScanNumber(signal.getRetentionTime()))) != null) {
                            double abundance = scanMaster.getTotalSignal() - signal.getTotalSignal();
                            double xOffset = offset.getCurrentXOffset();
                            double yOffset = offset.getCurrentYOffset();
                            xSeries[x++] = retentionTime += xOffset;
                            ySeries[y++] = abundance += yOffset;
                        }
                        ++scan;
                    }
                    offset.incrementCurrentXOffset();
                    offset.incrementCurrentYOffset();
                    chromatogramSeries.add(new Series(xSeries, ySeries, "[" + i + "] " + chromatogramMaster.getName() + " - " + chromatogram.getName()));
                }
                ++i;
            }
        }
        return chromatogramSeries;
    }

    public static ISeries convertChromatogram(IChromatogramSelection chromatogramSelection, Sign sign, boolean validatePositive) {
        return SeriesConverter.convertChromatogram(chromatogramSelection, sign, false, validatePositive);
    }

    public static ISeries convertChromatogram(IChromatogramSelection chromatogramSelection, Sign sign, boolean useLockedOffset, boolean validatePositive) {
        ArrayList<IChromatogramSelection> chromatogramSelections = new ArrayList<IChromatogramSelection>();
        chromatogramSelections.add(chromatogramSelection);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries chromatogramSelectionSeries = SeriesConverter.convertChromatograms(chromatogramSelections, sign, offset, useLockedOffset, validatePositive);
        return chromatogramSelectionSeries.getMultipleSeries().get(0);
    }

    public static IMultipleSeries convertDerivativeChromatogram(IChromatogramSelection chromatogramSelection, int derivative, int scale, boolean validatePositive) {
        int stopScan;
        int startScan;
        MultipleSeries multipleSeries = new MultipleSeries();
        int masterStartRetentionTime = chromatogramSelection.getStartRetentionTime();
        int masterStopRetentionTime = chromatogramSelection.getStopRetentionTime();
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        ITotalScanSignals signals = SeriesConverter.getTotalScanSignals(chromatogram, startScan = SeriesConverter.getStartScan(masterStartRetentionTime, chromatogram), stopScan = SeriesConverter.getStopScan(masterStopRetentionTime, chromatogram), validatePositive);
        if (signals != null) {
            int scans = SeriesConverter.getSizeWithRetentionTimeGreatherThanZero(signals);
            double[] xSeries = new double[scans];
            double[] ySeries = new double[scans];
            int x = 0;
            int y = 0;
            double abundance = 0.0;
            for (ITotalScanSignal signal : signals.getTotalScanSignals()) {
                double retentionTime = signal.getRetentionTime();
                abundance = signal.getTotalSignal();
                if (retentionTime == 0.0) continue;
                xSeries[x++] = retentionTime;
                ySeries[y++] = abundance;
            }
            multipleSeries.add(new Series(xSeries, ySeries, chromatogram.getName()));
            double[] ySeriesBase = ySeries;
            double[] ySeriesDerivative = new double[scans];
            int i = 0;
            while (i < derivative) {
                ySeriesDerivative = new double[scans];
                int j = 1;
                while (j < scans) {
                    ySeriesDerivative[j] = (ySeriesBase[j] - ySeriesBase[j - 1]) * (double)scale;
                    ++j;
                }
                ySeriesBase = ySeriesDerivative;
                ++i;
            }
            multipleSeries.add(new Series(xSeries, ySeriesDerivative, String.valueOf(derivative) + ". Derivative scale[" + scale + "]"));
        }
        return multipleSeries;
    }

    public static ISeries convertChromatogram(IChromatogram chromatogram, Sign sign, boolean validatePositive) {
        return SeriesConverter.convertChromatogram(chromatogram, sign, false, validatePositive);
    }

    public static ISeries convertChromatogram(IChromatogram chromatogram, Sign sign, boolean useLockedOffset, boolean validatePositive) {
        ISeries series = null;
        try {
            ChromatogramSelection chromatogramSelection = new ChromatogramSelection(chromatogram);
            series = SeriesConverter.convertChromatogram((IChromatogramSelection)chromatogramSelection, sign, useLockedOffset, validatePositive);
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        return series;
    }

    public static ISeries convertBaseline(IChromatogramSelection chromatogramSelection, Sign sign, boolean validatePositive) {
        Series baselineSeries = null;
        if (chromatogramSelection != null) {
            int stopScan;
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            IBaselineModel baselineModel = chromatogram.getBaselineModel();
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            ITotalScanSignals signals = SeriesConverter.getTotalScanSignals(chromatogram, startScan, stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime()), validatePositive);
            if (signals != null) {
                int scans = signals.size();
                double[] xSeries = new double[scans];
                double[] ySeries = new double[scans];
                int x = 0;
                int y = 0;
                for (ITotalScanSignal signal : signals.getTotalScanSignals()) {
                    xSeries[x++] = signal.getRetentionTime();
                    double abundance = baselineModel.getBackgroundAbundance(signal.getRetentionTime());
                    if (sign == Sign.NEGATIVE) {
                        abundance *= -1.0;
                    }
                    ySeries[y++] = abundance;
                }
                baselineSeries = new Series(xSeries, ySeries, "Baseline");
            }
        }
        return baselineSeries;
    }

    public static IOffset validateOffset(IOffset offset) {
        if (offset == null) {
            offset = new Offset(0.0, 0.0);
        }
        return offset;
    }

    public static ITotalScanSignals getTotalScanSignals(IChromatogram chromatogram, int startScan, int stopScan, boolean validatePositive) {
        if (PreferenceSupplier.condenseCycleNumberScans() && chromatogram.containsScanCycles()) {
            return SeriesConverter.getTotalScanSignals(chromatogram, startScan, stopScan, validatePositive, true);
        }
        return SeriesConverter.getTotalScanSignals(chromatogram, startScan, stopScan, validatePositive, false);
    }

    private static ITotalScanSignals getTotalScanSignals(IChromatogram chromatogram, int startScan, int stopScan, boolean validatePositive, boolean condenseCycleNumberScans) {
        try {
            TotalScanSignalExtractor totalIonSignalExtractor = new TotalScanSignalExtractor(chromatogram);
            ITotalScanSignals signals = totalIonSignalExtractor.getTotalScanSignals(startScan, stopScan, validatePositive, condenseCycleNumberScans);
            return signals;
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
            return null;
        }
    }

    public static int getStartScan(int masterStartRetentionTime, IChromatogram chromatogram) {
        assert (chromatogram != null) : "The chromatogram must be not null.";
        int scan = 0;
        int startRetentionTime = chromatogram.getStartRetentionTime();
        int stopRetentionTime = chromatogram.getStopRetentionTime();
        if (masterStartRetentionTime <= startRetentionTime) {
            scan = 1;
        } else if (masterStartRetentionTime > startRetentionTime && masterStartRetentionTime <= stopRetentionTime) {
            scan = chromatogram.getScanNumber(masterStartRetentionTime);
        }
        return scan;
    }

    public static int getStopScan(int masterStopRetentionTime, IChromatogram chromatogram) {
        assert (chromatogram != null) : "The chromatogram must be not null.";
        int scan = 0;
        int startRetentionTime = chromatogram.getStartRetentionTime();
        int stopRetentionTime = chromatogram.getStopRetentionTime();
        if (masterStopRetentionTime >= stopRetentionTime) {
            scan = chromatogram.getNumberOfScans();
        } else if (masterStopRetentionTime < stopRetentionTime && masterStopRetentionTime >= startRetentionTime) {
            scan = chromatogram.getScanNumber(masterStopRetentionTime);
        }
        return scan;
    }

    public static int getSizeWithRetentionTimeGreatherThanZero(ITotalScanSignals signals) {
        int counter = 0;
        for (ITotalScanSignal signal : signals.getTotalScanSignals()) {
            if (signal.getRetentionTime() <= 0) continue;
            ++counter;
        }
        return counter;
    }

    public static ISeries convertSelectedPeak(IPeak peak, boolean includeBackground, Sign sign) {
        ArrayList<IPeak> peaks = new ArrayList<IPeak>();
        peaks.add(peak);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries peakSeries = SeriesConverter.convertPeaks(peaks, includeBackground, sign, offset);
        return peakSeries.getMultipleSeries().get(0);
    }

    public static ISeries convertSelectedPeakBackground(IPeak peak, Sign sign) {
        ArrayList<IPeak> peaks = new ArrayList<IPeak>();
        peaks.add(peak);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries peakSeries = SeriesConverter.convertPeakBackground(peaks, sign, offset);
        return peakSeries.getMultipleSeries().get(0);
    }

    public static ISeries convertPeak(IPeak peak, boolean includeBackground, Sign sign) {
        ArrayList<IPeak> peaks = new ArrayList<IPeak>();
        peaks.add(peak);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries peakSeries = SeriesConverter.convertPeaks(peaks, includeBackground, sign, offset);
        return peakSeries.getMultipleSeries().get(0);
    }

    public static ISeries convertPeakBackground(IPeak peak, Sign sign) {
        ArrayList<IPeak> peaks = new ArrayList<IPeak>();
        peaks.add(peak);
        Offset offset = new Offset(0.0, 0.0);
        IMultipleSeries peakSeries = SeriesConverter.convertPeakBackground(peaks, sign, offset);
        return peakSeries.getMultipleSeries().get(0);
    }

    public static IMultipleSeries convertPeaks(List<? extends IPeak> peaks, boolean includeBackground, Sign sign, IOffset offset) {
        MultipleSeries peakSeries = new MultipleSeries();
        if (peaks != null) {
            offset = SeriesConverter.validateOffset(offset);
            for (IPeak iPeak : peaks) {
                if (iPeak == null) continue;
                IPeakModel peakModel = iPeak.getPeakModel();
                int size = peakModel.getRetentionTimes().size();
                double[] xSeries = new double[size];
                double[] ySeries = new double[size];
                int x = 0;
                int y = 0;
                Iterator iterator = peakModel.getRetentionTimes().iterator();
                while (iterator.hasNext()) {
                    int retentionTime = (Integer)iterator.next();
                    double abundance = peakModel.getPeakAbundance(retentionTime);
                    if (includeBackground) {
                        abundance += (double)peakModel.getBackgroundAbundance(retentionTime);
                    }
                    double xOffset = offset.getCurrentXOffset();
                    double yOffset = offset.getCurrentYOffset();
                    if (sign == Sign.NEGATIVE) {
                        abundance *= -1.0;
                        xOffset *= -1.0;
                        yOffset *= -1.0;
                    }
                    retentionTime = (int)((double)retentionTime + xOffset);
                    xSeries[x++] = retentionTime;
                    ySeries[y++] = abundance += yOffset;
                }
                offset.incrementCurrentXOffset();
                offset.incrementCurrentYOffset();
                peakSeries.add(new Series(xSeries, ySeries, "Peak"));
            }
        }
        return peakSeries;
    }

    public static IMultipleSeries convertPeakBackground(List<? extends IPeak> peaks, Sign sign, IOffset offset) {
        MultipleSeries peakBackgroundSeries = new MultipleSeries();
        if (peaks != null) {
            offset = SeriesConverter.validateOffset(offset);
            for (IPeak iPeak : peaks) {
                if (iPeak == null) continue;
                IPeakModel peakModel = iPeak.getPeakModel();
                int size = peakModel.getRetentionTimes().size();
                double[] xSeries = new double[size];
                double[] ySeries = new double[size];
                int x = 0;
                int y = 0;
                Iterator iterator = peakModel.getRetentionTimes().iterator();
                while (iterator.hasNext()) {
                    int retentionTime = (Integer)iterator.next();
                    double abundance = peakModel.getBackgroundAbundance(retentionTime);
                    double xOffset = offset.getCurrentXOffset();
                    double yOffset = offset.getCurrentYOffset();
                    if (sign == Sign.NEGATIVE) {
                        abundance *= -1.0;
                        xOffset *= -1.0;
                        yOffset *= -1.0;
                    }
                    retentionTime = (int)((double)retentionTime + xOffset);
                    xSeries[x++] = retentionTime;
                    ySeries[y++] = abundance += yOffset;
                }
                offset.incrementCurrentXOffset();
                offset.incrementCurrentYOffset();
                peakBackgroundSeries.add(new Series(xSeries, ySeries, "Background"));
            }
        }
        return peakBackgroundSeries;
    }

    public static IMultipleSeries convertPeakMaxMarker(List<? extends IPeak> peaks, Sign sign, IOffset offset, boolean activeForAnalysis) throws NoPeaksAvailableException {
        MultipleSeries peakSeries = new MultipleSeries();
        if (peaks != null) {
            offset = SeriesConverter.validateOffset(offset);
            int amountPeaks = SeriesConverter.getAmountPeaks(peaks, activeForAnalysis);
            if (amountPeaks == 0) {
                throw new NoPeaksAvailableException();
            }
            double[] xSeries = new double[amountPeaks];
            double[] ySeries = new double[amountPeaks];
            int x = 0;
            int y = 0;
            for (IPeak iPeak : peaks) {
                if (!SeriesConverter.printPeak(iPeak, activeForAnalysis)) continue;
                IPeakModel peakModel = iPeak.getPeakModel();
                double retentionTime = peakModel.getRetentionTimeAtPeakMaximum();
                double abundance = peakModel.getBackgroundAbundance() + peakModel.getPeakAbundance();
                double xOffset = offset.getCurrentXOffset();
                double yOffset = offset.getCurrentYOffset();
                if (sign == Sign.NEGATIVE) {
                    abundance *= -1.0;
                    xOffset *= -1.0;
                    yOffset *= -1.0;
                }
                xSeries[x++] = retentionTime += xOffset;
                ySeries[y++] = abundance += yOffset;
            }
            if (activeForAnalysis) {
                peakSeries.add(new Series(xSeries, ySeries, "Active Peaks"));
            } else {
                peakSeries.add(new Series(xSeries, ySeries, "Inactive Peaks"));
            }
        }
        return peakSeries;
    }

    private static int getAmountPeaks(List<? extends IPeak> peaks, boolean activeForAnalysis) {
        int amountPeaks = 0;
        for (IPeak iPeak : peaks) {
            if (!SeriesConverter.printPeak(iPeak, activeForAnalysis)) continue;
            ++amountPeaks;
        }
        return amountPeaks;
    }

    private static boolean printPeak(IPeak peak, boolean activeForAnalysis) {
        return activeForAnalysis == peak.isActiveForAnalysis();
    }
}

