/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.compilation.marketplace.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.rcp.app.compilation.marketplace.ui.Activator;
import org.eclipse.chemclipse.rcp.app.ui.support.UpdateSiteSupport;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.LabelFieldEditor;
import org.eclipse.chemclipse.support.ui.preferences.fieldeditors.SpacerFieldEditor;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.MarketplaceClient;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MarketplacePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger logger = Logger.getLogger(MarketplacePreferencePage.class);

    public MarketplacePreferencePage() {
        super(1);
        this.setDescription("Add the marketplace on demand, to fetch additional plug-ins.");
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new SpacerFieldEditor(this.getFieldEditorParent()));
        this.addField((FieldEditor)new LabelFieldEditor("The marketplace offers additional plugins.", this.getFieldEditorParent()));
        Button addMarketplace = new Button(this.getFieldEditorParent(), 0);
        addMarketplace.setText("Add OpenChrom Marketplace");
        addMarketplace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 450);
                messageBox.setText("Add OpenChrom Marketplace");
                messageBox.setMessage("Do you really want to add the marketplace?");
                if (messageBox.open() == 64) {
                    try {
                        URL url = new URL("http://www.openchrom.net/");
                        CatalogDescriptor catalogDescriptor = new CatalogDescriptor(url, "OpenChrom Marketplace");
                        catalogDescriptor.setDescription("Install new plug-ins from the marketplace.");
                        catalogDescriptor.setIcon(Activator.imageDescriptorFromPlugin((String)Activator.getDefault().getBundle().getSymbolicName(), (String)"icons/logo_32x32.png"));
                        catalogDescriptor.setInstallFromAllRepositories(false);
                        MarketplaceClient.addCatalogDescriptor((CatalogDescriptor)catalogDescriptor);
                        UpdateSiteSupport updateSiteSupport = new UpdateSiteSupport();
                        HashMap<String, String> updateSites = new HashMap<String, String>();
                        updateSites.put("OpenChrom 3rd Party Libraries", "http://update.openchrom.net/repositories/community/1.0.x/plugins/openchrom3rdpl");
                        updateSites.put("OpenChrom Keys", "http://update.openchrom.net/repositories/community/1.0.x/plugins/openchromkeys");
                        updateSites.put("OpenChrom Icons", "http://update.openchrom.net/repositories/community/1.0.x/plugins/enterprisesupport");
                        updateSites.put("OpenChrom xIdent", "http://update.openchrom.net/repositories/community/1.0.x/plugins/xident");
                        updateSiteSupport.addProvisioningRepositories(updateSites);
                    }
                    catch (MalformedURLException e1) {
                        logger.warn((Object)e1);
                    }
                }
            }
        });
    }
}

