/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListener;
import org.eclipse.core.internal.databinding.beans.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValueProperty<S, T>
extends SimpleValueProperty<S, T> {
    private final PropertyDescriptor propertyDescriptor;
    private final Class<T> valueType;

    public BeanValueProperty(PropertyDescriptor propertyDescriptor, Class<T> valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("valueType cannot be null.");
        }
        Class<?> propertyType = propertyDescriptor.getPropertyType();
        if (valueType != (propertyType = Util.convertToObjectClass(propertyType))) {
            throw new IllegalArgumentException("valueType does not match the actual property type.");
        }
        this.propertyDescriptor = propertyDescriptor;
        this.valueType = valueType;
    }

    public Class<T> getValueType() {
        return this.valueType;
    }

    public Class<T> getValueClass() {
        return this.valueType;
    }

    protected T doGetValue(S source) {
        Object value = BeanPropertyHelper.readProperty(source, this.propertyDescriptor);
        return this.valueType.cast(value);
    }

    protected void doSetValue(S source, T value) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, value);
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<ValueDiff<T>> listener) {
        return new BeanPropertyListener<S, ValueDiff<T>>((IProperty)this, this.propertyDescriptor, listener){

            @Override
            protected ValueDiff<T> computeDiff(Object oldValue, Object newValue) {
                return Diffs.createValueDiff(BeanValueProperty.this.valueType.cast(oldValue), BeanValueProperty.this.valueType.cast(newValue));
            }
        };
    }

    public String toString() {
        String s = BeanPropertyHelper.propertyName(this.propertyDescriptor);
        if (this.valueType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.valueType) + ">";
        }
        return s;
    }
}

