/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.swt.ui.components.chromatogram;

import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.marker.MouseMoveMarker;
import org.eclipse.chemclipse.swt.ui.marker.SelectedPositionMarker;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.series.Series;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.swt.ui.components.chromatogram.AbstractEditorChromatogramUI;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

public class EditorChromatogramUI
extends AbstractEditorChromatogramUI {
    private MouseMoveMarker mouseMoveMarker;
    private SelectedPositionMarker selectedPositionMarker;

    public EditorChromatogramUI(Composite parent, int style) {
        super(parent, style);
        boolean yMinimumToZero = PreferenceSupplier.showBackgroundInChromatogramEditor();
        this.setYMinimumToZero(yMinimumToZero);
    }

    public void setViewSeries() {
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionWSD) {
            IChromatogramSelectionWSD chromatogramSelection = (IChromatogramSelectionWSD)storedChromatogramSelection;
            ISeries series = SeriesConverter.convertChromatogram((IChromatogramSelection)chromatogramSelection, (Sign)Sign.POSITIVE, (boolean)false);
            this.addSeries(series);
            ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(Colors.RED);
            IScanWSD selectedScan = chromatogramSelection.getSelectedScan();
            if (selectedScan != null) {
                series = this.getSelectedScanSeries((IScan)selectedScan);
                ILineSeries selectedScanSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
                selectedScanSeries.setXSeries(series.getXSeries());
                selectedScanSeries.setYSeries(series.getYSeries());
                selectedScanSeries.setLineStyle(LineStyle.NONE);
                selectedScanSeries.setSymbolType(ILineSeries.PlotSymbolType.CROSS);
                selectedScanSeries.setSymbolSize(5);
                selectedScanSeries.setSymbolColor(Colors.DARK_RED);
            }
        }
    }

    private ISeries getSelectedScanSeries(IScan selectedScan) {
        double[] xSeries = new double[]{selectedScan.getRetentionTime()};
        int totalSignal = (int)selectedScan.getTotalSignal();
        double[] ySeries = new double[]{totalSignal};
        return new Series(xSeries, ySeries, "Selected Scan");
    }

    protected void initialize() {
        super.initialize();
        IPlotArea plotArea = (IPlotArea)this.getPlotArea();
        this.mouseMoveMarker = new MouseMoveMarker();
        plotArea.addCustomPaintListener((ICustomPaintListener)this.mouseMoveMarker);
        if (PreferenceSupplier.showChromatogramPositionMarkerBox()) {
            Color foregroundColor = PreferenceSupplier.getPositionMarkerForegroundColor();
            Color backgroundColor = PreferenceSupplier.getPositionMarkerBackgroundColor();
            this.selectedPositionMarker = new SelectedPositionMarker(foregroundColor, backgroundColor);
            plotArea.addCustomPaintListener((ICustomPaintListener)this.selectedPositionMarker);
            this.getPlotArea().addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    EditorChromatogramUI.this.mouseMoveMarker.setXPosition(e.x);
                    double abundance = EditorChromatogramUI.this.getSelectedAbundance(e.y);
                    int retentionTimeInMilliseconds = EditorChromatogramUI.this.getSelectedRetentionTimeAsMilliseconds(e.x);
                    EditorChromatogramUI.this.selectedPositionMarker.setActualPosition(retentionTimeInMilliseconds, abundance);
                    EditorChromatogramUI.this.getPlotArea().redraw();
                }
            });
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.button == 1) {
            this.handleScanSelection(e.x);
        }
    }

    public void mouseScrolled(MouseEvent e) {
        this.handleMouseWheelSelection(e);
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.keyCode;
        int stateMask = e.stateMask;
        if (stateMask == 262144) {
            if (keyCode == 0x1000004 || keyCode == 0x1000003) {
                this.handleControlScanSelection(keyCode);
            } else {
                super.keyPressed(e);
            }
        } else if (keyCode == 0x1000004 || keyCode == 0x1000003 || keyCode == 0x1000001 || keyCode == 0x1000002) {
            this.handleArrowMoveWindowSelection(keyCode);
        }
    }
}

