/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.swt.ui.components.chromatogram;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelength;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelengths;
import org.eclipse.chemclipse.wsd.model.core.support.MarkedWavelength;
import org.eclipse.chemclipse.wsd.swt.ui.internal.provider.MarkedWavelengthsChooserContentProvider;
import org.eclipse.chemclipse.wsd.swt.ui.internal.provider.MarkedWavelengthsChooserLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MarkedWavelengthsChooser {
    private IMarkedWavelengths markedWavelengths;
    private ExtendedTableViewer tableViewer;
    private Label label;
    private String labelText;
    private Text textWavelengthToAdd;
    private Text textMagnification;
    private NumberFormat numberFormat;
    private String[] titles = new String[]{"Wavelength", "Magnification"};
    private int[] bounds = new int[]{100, 100};

    public MarkedWavelengthsChooser(Composite parent, int style) {
        this.numberFormat = ValueFormat.getNumberFormatEnglish();
        this.initialize(parent);
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        if (this.label != null) {
            this.labelText = labelText;
            this.label.setText(labelText);
        }
    }

    public IMarkedWavelengths getMarkedIons() {
        return this.markedWavelengths;
    }

    public void setMarkedWavelengths(IMarkedWavelengths markedWavelengths) {
        if (markedWavelengths != null) {
            this.markedWavelengths = markedWavelengths;
            if (this.tableViewer != null) {
                this.tableViewer.setInput((Object)markedWavelengths);
            }
        }
    }

    private void initialize(Composite parent) {
        Composite compositeMarkedIonChooser = new Composite(parent, 0);
        compositeMarkedIonChooser.setLayout((Layout)new GridLayout(3, false));
        GridData gridDataComposite = new GridData(1808);
        gridDataComposite.grabExcessHorizontalSpace = true;
        gridDataComposite.grabExcessVerticalSpace = true;
        compositeMarkedIonChooser.setLayoutData((Object)gridDataComposite);
        this.label = new Label(compositeMarkedIonChooser, 0);
        this.labelText = "Edit marked ions.";
        this.label.setText(this.labelText);
        this.label.setLayoutData((Object)new GridData(768));
        Label label1 = new Label(compositeMarkedIonChooser, 0);
        label1.setText("Wavelength");
        label1.setLayoutData((Object)new GridData(768));
        Label label2 = new Label(compositeMarkedIonChooser, 0);
        label2.setText("Magnification");
        label2.setLayoutData((Object)new GridData(768));
        Composite compositeEditor = new Composite(compositeMarkedIonChooser, 0);
        compositeEditor.setLayout((Layout)new FillLayout());
        GridData gridDataEditor = new GridData();
        gridDataEditor.horizontalAlignment = 4;
        gridDataEditor.verticalAlignment = 4;
        gridDataEditor.verticalSpan = 2;
        gridDataEditor.grabExcessHorizontalSpace = true;
        gridDataEditor.grabExcessVerticalSpace = true;
        gridDataEditor.heightHint = 230;
        gridDataEditor.widthHint = 150;
        compositeEditor.setLayoutData((Object)gridDataEditor);
        this.tableViewer = new ExtendedTableViewer(compositeEditor, 68354);
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)new MarkedWavelengthsChooserContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MarkedWavelengthsChooserLabelProvider());
        if (this.markedWavelengths != null) {
            this.tableViewer.setInput((Object)this.markedWavelengths);
        }
        this.tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    MarkedWavelengthsChooser.this.tableViewer.copyToClipboard(MarkedWavelengthsChooser.this.titles);
                }
            }
        });
        this.textWavelengthToAdd = new Text(compositeMarkedIonChooser, 2048);
        this.textWavelengthToAdd.setLayoutData((Object)new GridData(768));
        this.textWavelengthToAdd.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    MarkedWavelengthsChooser.this.addWavelength();
                }
            }
        });
        this.textMagnification = new Text(compositeMarkedIonChooser, 2048);
        this.textMagnification.setText("1");
        this.textMagnification.setLayoutData((Object)new GridData(768));
        GridData gridDataButton = new GridData(768);
        gridDataButton.verticalAlignment = 1;
        Button addWavelength = new Button(compositeMarkedIonChooser, 0);
        addWavelength.setText("Add Wavelength");
        addWavelength.setLayoutData((Object)gridDataButton);
        addWavelength.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkedWavelengthsChooser.this.addWavelength();
            }
        });
        Button removeWavelength = new Button(compositeMarkedIonChooser, 0);
        removeWavelength.setText("Remove Selected Wavelength(s)");
        removeWavelength.setLayoutData((Object)gridDataButton);
        removeWavelength.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MarkedWavelengthsChooser.this.tableViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)MarkedWavelengthsChooser.this.tableViewer.getSelection();
                    List ionList = structuredSelection.toList();
                    for (Object ion : ionList) {
                        MarkedWavelengthsChooser.this.removeMassFragement(ion);
                    }
                }
            }
        });
    }

    private void addWavelength() {
        block5: {
            String wavelength = this.textWavelengthToAdd.getText();
            String magnification = this.textMagnification.getText();
            if (wavelength != null && !wavelength.equals("") && magnification != null && !magnification.equals("")) {
                try {
                    int parsedWavelength = this.numberFormat.parse(wavelength).intValue();
                    int parsedMagnification = this.numberFormat.parse(magnification).intValue();
                    if (this.markedWavelengths != null && parsedWavelength > 0 && parsedMagnification >= 0) {
                        this.textWavelengthToAdd.setText("");
                        this.markedWavelengths.add((Object)new MarkedWavelength(parsedWavelength, parsedMagnification));
                        this.tableViewer.refresh();
                        break block5;
                    }
                    this.textWavelengthToAdd.setText("Wavelength (0) can't be added.");
                }
                catch (ParseException parseException) {
                    this.textWavelengthToAdd.setText("Please type in a valid wavelength.");
                }
            } else {
                this.textWavelengthToAdd.setText("The wavelength field must be not null.");
            }
        }
    }

    private void removeMassFragement(Object object) {
        if (object instanceof IMarkedWavelength) {
            IMarkedWavelength markedWavelength = (IMarkedWavelength)object;
            if (this.markedWavelengths != null) {
                this.markedWavelengths.remove((Object)markedWavelength);
                this.tableViewer.refresh();
            }
        }
    }
}

