/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.support;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.msd.model.core.support.IIonUniquenessValues;

public class IonUniquenessValues
implements IIonUniquenessValues {
    private static Map<Integer, Float> probabilityValues;

    public IonUniquenessValues() {
        probabilityValues = new HashMap<Integer, Float>();
    }

    @Override
    public void add(int ion, float probabilityValue) {
        if (probabilityValue >= 0.0f && probabilityValue <= 1.0f) {
            probabilityValues.put(ion, Float.valueOf(probabilityValue));
        }
    }

    @Override
    public void remove(int ion) {
        probabilityValues.remove(ion);
    }

    @Override
    public float getUniquenessValue(int ion) {
        float result = this.getPropabilityValue(ion);
        return 1.0f - result;
    }

    @Override
    public float getPropabilityValue(int ion) {
        Float result = probabilityValues.get(ion);
        if (result == null) {
            return 0.0f;
        }
        return result.floatValue();
    }
}

