/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.implementation;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractCombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.ICombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;

public class CombinedMassSpectrum
extends AbstractCombinedMassSpectrum
implements ICombinedMassSpectrum {
    private static final long serialVersionUID = 7845524326973176571L;
    private static final Logger logger = Logger.getLogger(ScanMSD.class);

    @Override
    public IScanMSD makeDeepCopy() throws CloneNotSupportedException {
        ICombinedMassSpectrum massSpectrum = (ICombinedMassSpectrum)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                Ion defaultIon = new Ion(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon(defaultIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

