/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.csd.converter.io.AbstractChromatogramCSDReader;
import org.eclipse.chemclipse.csd.converter.io.IChromatogramCSDReader;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1001;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1002;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1003;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1004;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1005;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1006;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1007;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.ChromatogramReader_1100;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.model.chromatogram.VendorChromatogram;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.model.chromatogram.VendorScan;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.ChromatogramReaderMSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.ReaderHelper;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReaderCSD
extends AbstractChromatogramCSDReader
implements IChromatogramCSDReader {
    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramCSD chromatogramOverview = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(file);
        AbstractChromatogramReader chromatogramReader = null;
        if (version.equals("1.0.0.1")) {
            chromatogramReader = new ChromatogramReader_1001();
        } else if (version.equals("1.0.0.2")) {
            chromatogramReader = new ChromatogramReader_1002();
        } else if (version.equals("1.0.0.3")) {
            chromatogramReader = new ChromatogramReader_1003();
        } else if (version.equals("1.0.0.4")) {
            chromatogramReader = new ChromatogramReader_1004();
        } else if (version.equals("1.0.0.5")) {
            chromatogramReader = new ChromatogramReader_1005();
        } else if (version.equals("1.0.0.6")) {
            chromatogramReader = new ChromatogramReader_1006();
        } else if (version.equals("1.0.0.7")) {
            chromatogramReader = new ChromatogramReader_1007();
        } else if (version.equals("1.1.0.0")) {
            chromatogramReader = new ChromatogramReader_1100();
        }
        if (chromatogramReader != null) {
            try {
                chromatogramOverview = chromatogramReader.readOverview(file, monitor);
            }
            catch (Exception exception) {
                chromatogramOverview = this.createChromatogramFIDFromMSD(file, monitor);
            }
        } else {
            chromatogramOverview = this.createChromatogramFIDFromMSD(file, monitor);
        }
        return chromatogramOverview;
    }

    public IChromatogramCSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramCSD chromatogramFID = null;
        ReaderHelper readerHelper = new ReaderHelper();
        String version = readerHelper.getVersion(file);
        AbstractChromatogramReader chromatogramReader = null;
        if (version.equals("1.0.0.1")) {
            chromatogramReader = new ChromatogramReader_1001();
        } else if (version.equals("1.0.0.2")) {
            chromatogramReader = new ChromatogramReader_1002();
        } else if (version.equals("1.0.0.3")) {
            chromatogramReader = new ChromatogramReader_1003();
        } else if (version.equals("1.0.0.4")) {
            chromatogramReader = new ChromatogramReader_1004();
        } else if (version.equals("1.0.0.5")) {
            chromatogramReader = new ChromatogramReader_1005();
        } else if (version.equals("1.0.0.6")) {
            chromatogramReader = new ChromatogramReader_1006();
        } else if (version.equals("1.0.0.7")) {
            chromatogramReader = new ChromatogramReader_1007();
        } else if (version.equals("1.1.0.0")) {
            chromatogramReader = new ChromatogramReader_1100();
        }
        if (chromatogramReader != null) {
            try {
                chromatogramFID = chromatogramReader.read(file, monitor);
            }
            catch (Exception exception) {
                chromatogramFID = this.createChromatogramFIDFromMSD(file, monitor);
            }
        } else {
            chromatogramFID = this.createChromatogramFIDFromMSD(file, monitor);
        }
        return chromatogramFID;
    }

    private IChromatogramCSD createChromatogramFIDFromMSD(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        ChromatogramReaderMSD chromatogramReaderMSD;
        IChromatogramOverview chromatogramOverview;
        VendorChromatogram chromatogramFID = null;
        if (PreferenceSupplier.isForceLoadAlternateDetector() && (chromatogramOverview = (chromatogramReaderMSD = new ChromatogramReaderMSD()).readOverview(file, monitor)) instanceof IChromatogram) {
            int startRetentionTime;
            IChromatogram chromatogram = (IChromatogram)chromatogramOverview;
            chromatogramFID = new VendorChromatogram();
            for (IScan scan : chromatogram.getScans()) {
                VendorScan scanFID = new VendorScan(scan.getRetentionTime(), scan.getTotalSignal());
                scanFID.setRetentionIndex(scan.getRetentionIndex());
                scanFID.setTimeSegmentId(scan.getTimeSegmentId());
                scanFID.setCycleNumber(scan.getCycleNumber());
                chromatogramFID.addScan((IScan)scanFID);
            }
            chromatogramFID.setConverterId("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse");
            File fileConverted = new File(file.getAbsolutePath().replace(".ocb", "-fromMSD.ocb"));
            chromatogramFID.setFile(fileConverted);
            int scanDelay = startRetentionTime = chromatogramFID.getStartRetentionTime();
            chromatogramFID.setScanDelay(scanDelay);
            int endRetentionTime = chromatogramFID.getStopRetentionTime();
            int scanInterval = endRetentionTime / chromatogramFID.getNumberOfScans();
            chromatogramFID.setScanInterval(scanInterval);
        }
        return chromatogramFID;
    }
}

