/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.io.File;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PageCalibrationSettings
extends AbstractExtendedWizardPage {
    private IRetentionIndexWizardElements wizardElements;
    private String[] availableStandards;
    private Button checkBoxUseExistingCalibrationFile;
    private Text textPathRetentionIndexFile;
    private Button buttonSelectCalibrationFile;
    private Button buttonMSD;
    private Button buttonCSD;
    private Combo comboStartIndexName;
    private Combo comboStopIndexName;
    private Button checkBoxUseExistingPeaks;

    public PageCalibrationSettings(IRetentionIndexWizardElements wizardElements) {
        super(PageCalibrationSettings.class.getName());
        this.setTitle("Calibration Settings");
        this.setDescription("Please select the calibration settings.");
        this.wizardElements = wizardElements;
        this.availableStandards = wizardElements.getAvailableStandards();
    }

    public boolean canFinish() {
        return this.getMessage() == null;
    }

    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.checkBoxUseExistingCalibrationFile.setSelection(this.wizardElements.isUseExistingRetentionIndexFile());
            this.setCalibrationFileSelection(this.wizardElements.isUseExistingRetentionIndexFile());
            this.comboStartIndexName.select(this.getComboIndex(this.wizardElements.getStartIndexName()));
            this.comboStopIndexName.select(this.getComboIndex(this.wizardElements.getStopIndexName()));
            this.checkBoxUseExistingPeaks.setSelection(this.wizardElements.isUseAlreadyDetectedPeaks());
            this.validateSelection();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createCalibrationFileField(composite);
        this.createLabelDataField(composite);
        this.createButtonMSDField(composite);
        this.createButtonCSDField(composite);
        this.createStartRetentionIndexField(composite);
        this.createStopRetentionIndexField(composite);
        this.createPeakIdentificationField(composite);
        this.validateSelection();
        this.setControl((Control)composite);
    }

    private void createCalibrationFileField(Composite composite) {
        this.checkBoxUseExistingCalibrationFile = new Button(composite, 32);
        this.checkBoxUseExistingCalibrationFile.setText("Use existing *.cal file for improved detection");
        this.checkBoxUseExistingCalibrationFile.setEnabled(true);
        this.checkBoxUseExistingCalibrationFile.setLayoutData((Object)this.getGridData());
        this.checkBoxUseExistingCalibrationFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useExistingCalibrationFile = PageCalibrationSettings.this.checkBoxUseExistingCalibrationFile.getSelection();
                PageCalibrationSettings.this.wizardElements.setUseExistingRetentionIndexFile(useExistingCalibrationFile);
                PageCalibrationSettings.this.setCalibrationFileSelection(useExistingCalibrationFile);
                PageCalibrationSettings.this.validateSelection();
            }
        });
        this.textPathRetentionIndexFile = new Text(composite, 2048);
        this.textPathRetentionIndexFile.setText("");
        this.textPathRetentionIndexFile.setLayoutData((Object)new GridData(768));
        this.textPathRetentionIndexFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCalibrationSettings.this.wizardElements.setPathRetentionIndexFile(PageCalibrationSettings.this.textPathRetentionIndexFile.getText().trim());
                PageCalibrationSettings.this.validateSelection();
            }
        });
        this.buttonSelectCalibrationFile = new Button(composite, 8);
        this.buttonSelectCalibrationFile.setText("Select *.cal");
        this.buttonSelectCalibrationFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8);
                fileDialog.setText("Select an existing *.cal template file.");
                fileDialog.setFilterExtensions(new String[]{"*.CAL", "*.cal"});
                fileDialog.setFilterNames(new String[]{"AMDIS Calibration *.CAL", "AMDIS Calibration *.cal"});
                fileDialog.setFilterPath(PageCalibrationSettings.this.wizardElements.getFilterPathCalibrationFile());
                String pathRetentionIndexFile = fileDialog.open();
                if (pathRetentionIndexFile != null) {
                    PageCalibrationSettings.this.textPathRetentionIndexFile.setText(pathRetentionIndexFile);
                    PageCalibrationSettings.this.wizardElements.setFilterPathCalibrationFile(fileDialog.getFilterPath());
                    PageCalibrationSettings.this.wizardElements.setPathRetentionIndexFile(pathRetentionIndexFile);
                    PageCalibrationSettings.this.validateSelection();
                }
            }
        });
    }

    private void createLabelDataField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Select whether to use MSD or CSD data to detect the RI pattern.");
        label.setLayoutData((Object)this.getGridData());
    }

    private void createButtonMSDField(Composite composite) {
        this.buttonMSD = new Button(composite, 16);
        this.buttonMSD.setText("MSD (Quadrupole, IonTrap, ...) data");
        this.buttonMSD.setSelection(this.wizardElements.isUseMassSpectrometryData());
        this.buttonMSD.setLayoutData((Object)this.getGridData());
        this.buttonMSD.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageCalibrationSettings.this.wizardElements.setUseMassSpectrometryData(true);
            }
        });
    }

    private void createButtonCSDField(Composite composite) {
        this.buttonCSD = new Button(composite, 16);
        this.buttonCSD.setText("CSD (FID, ECD, ...) data");
        this.buttonCSD.setSelection(!this.wizardElements.isUseMassSpectrometryData());
        this.buttonCSD.setLayoutData((Object)this.getGridData());
        this.buttonCSD.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageCalibrationSettings.this.wizardElements.setUseMassSpectrometryData(false);
            }
        });
    }

    private void createStartRetentionIndexField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Start Index");
        label.setLayoutData((Object)this.getGridData());
        this.comboStartIndexName = new Combo(composite, 0);
        this.comboStartIndexName.setLayoutData((Object)this.getGridData());
        this.comboStartIndexName.setItems(this.availableStandards);
        this.comboStartIndexName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageCalibrationSettings.this.wizardElements.setStartIndexName(PageCalibrationSettings.this.comboStartIndexName.getText().trim());
                PageCalibrationSettings.this.validateSelection();
            }
        });
    }

    private void createStopRetentionIndexField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Stop Index");
        label.setLayoutData((Object)this.getGridData());
        this.comboStopIndexName = new Combo(composite, 0);
        this.comboStopIndexName.setLayoutData((Object)this.getGridData());
        this.comboStopIndexName.setItems(this.availableStandards);
        this.comboStopIndexName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageCalibrationSettings.this.wizardElements.setStopIndexName(PageCalibrationSettings.this.comboStopIndexName.getText().trim());
                PageCalibrationSettings.this.validateSelection();
            }
        });
    }

    private void createPeakIdentificationField(Composite composite) {
        this.checkBoxUseExistingPeaks = new Button(composite, 32);
        this.checkBoxUseExistingPeaks.setText("Use existing peaks in chromatogram if available.");
        this.checkBoxUseExistingPeaks.setEnabled(true);
        this.checkBoxUseExistingPeaks.setLayoutData((Object)this.getGridData());
        this.checkBoxUseExistingPeaks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageCalibrationSettings.this.wizardElements.setUseAlreadyDetectedPeaks(PageCalibrationSettings.this.checkBoxUseExistingPeaks.getSelection());
            }
        });
    }

    private GridData getGridData() {
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 5;
        return gridData;
    }

    private void setCalibrationFileSelection(boolean enabled) {
        this.textPathRetentionIndexFile.setEnabled(enabled);
        this.buttonSelectCalibrationFile.setEnabled(enabled);
    }

    private int getComboIndex(String name) {
        int i = 0;
        while (i < this.availableStandards.length) {
            if (this.availableStandards[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void validateSelection() {
        String message = null;
        if (this.wizardElements.isUseExistingRetentionIndexFile()) {
            String pathCalibrationFile = this.wizardElements.getPathRetentionIndexFile();
            if (pathCalibrationFile.equals("")) {
                message = "Please select an existing calibration (*.cal) file.";
            } else {
                File file = new File(pathCalibrationFile);
                if (!file.exists()) {
                    message = "The selected *.cal doesn't exist.";
                }
            }
        }
        if (message == null) {
            String startIndexName = this.wizardElements.getStartIndexName();
            if (startIndexName.equals("")) {
                message = "Please select and start index.";
            } else if (this.getComboIndex(startIndexName) == -1) {
                message = "The select start index is not valid.";
            }
        }
        if (message == null) {
            String stopIndexName = this.wizardElements.getStopIndexName();
            if (stopIndexName.equals("")) {
                message = "Please select and stop index.";
            } else if (this.getComboIndex(stopIndexName) == -1) {
                message = "The select stop index is not valid.";
            }
        }
        this.updateStatus(message);
    }
}

