/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.compress;

import java.util.ArrayList;
import org.swtchart.internal.compress.Compress;

public class CompressLineSeries
extends Compress {
    private boolean isPrevOutOfRange;

    @Override
    protected void addNecessaryPlots(ArrayList<Double> xList, ArrayList<Double> yList, ArrayList<Integer> indexList) {
        this.isPrevOutOfRange = true;
        int i = 0;
        while (i < this.xSeries.length && i < this.ySeries.length) {
            STATE state = this.getState(i);
            switch (state) {
                case SteppingOutOfYRange: {
                    this.addToList(xList, yList, indexList, this.xSeries[i], this.ySeries[i], i);
                    break;
                }
                case SteppingOverYRange: 
                case SteppingInXRange: 
                case SteppingInRange: {
                    this.addToList(xList, yList, indexList, this.xSeries[i - 1], this.ySeries[i - 1], i - 1);
                    this.addToList(xList, yList, indexList, this.xSeries[i], this.ySeries[i], i);
                    break;
                }
                case SteppingOverXRange: 
                case SteppingOutOfXRange: {
                    this.addToList(xList, yList, indexList, this.xSeries[i - 1], this.ySeries[i - 1], i - 1);
                    this.addToList(xList, yList, indexList, this.xSeries[i], this.ySeries[i], i);
                    i = this.xSeries.length;
                    break;
                }
                case SteppingOutOfRange: {
                    this.addToList(xList, yList, indexList, this.xSeries[i], this.ySeries[i], i);
                    i = this.xSeries.length;
                    break;
                }
                case InRangeAgain: {
                    if (this.isInSameGridAsPrevious(this.xSeries[i], this.ySeries[i])) break;
                    this.addToList(xList, yList, indexList, this.xSeries[i], this.ySeries[i], i);
                    break;
                }
                case OutOfRangeAgain: {
                    break;
                }
            }
            ++i;
        }
    }

    private STATE getState(int index) {
        STATE state = this.xLower <= this.xSeries[index] && this.xSeries[index] <= this.xUpper ? (this.yLower <= this.ySeries[index] && this.ySeries[index] <= this.yUpper ? (index > 0 && this.isPrevOutOfRange ? STATE.SteppingInRange : STATE.InRangeAgain) : (this.isPrevOutOfRange ? (index > 0 && (this.ySeries[index - 1] < this.yLower && this.ySeries[index] > this.yUpper || this.ySeries[index - 1] > this.yUpper && this.ySeries[index] < this.yLower) ? STATE.SteppingOverYRange : (index > 0 && this.xSeries[index - 1] < this.xLower && this.xSeries[index] > this.xLower ? STATE.SteppingInXRange : STATE.OutOfRangeAgain)) : STATE.SteppingOutOfYRange)) : (!this.isPrevOutOfRange ? STATE.SteppingOutOfRange : (index > 0 && this.xSeries[index - 1] < this.xUpper && this.xSeries[index] > this.xUpper ? STATE.SteppingOutOfXRange : (index > 0 && this.xSeries[index - 1] < this.xLower && this.xSeries[index] > this.xUpper ? STATE.SteppingOverXRange : STATE.OutOfRangeAgain)));
        this.isPrevOutOfRange = !(this.xLower <= this.xSeries[index] && this.xSeries[index] <= this.xUpper && this.yLower <= this.ySeries[index] && this.ySeries[index] <= this.yUpper);
        return state;
    }

    static enum STATE {
        SteppingOverXRange,
        SteppingOverYRange,
        OutOfRangeAgain,
        SteppingOutOfXRange,
        SteppingInXRange,
        SteppingOutOfYRange,
        SteppingOutOfRange,
        InRangeAgain,
        SteppingInRange;

    }
}

