/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.ux.extension.csd.ui.internal.provider.PeakTargetsContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.views.AbstractTargetsView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PeakTargetsView
extends AbstractTargetsView {
    @Inject
    private Composite parent;
    @Inject
    private EPartService partService;
    @Inject
    private MPart part;
    private IEventBroker eventBroker;
    private EventHandler eventHandlerChromatogramSelection;
    private EventHandler eventHandlerPeak;
    private IPeakCSD peak;

    @Inject
    public PeakTargetsView(IEventBroker eventBroker) {
        super((IStructuredContentProvider)new PeakTargetsContentProvider(), eventBroker);
        this.eventBroker = eventBroker;
    }

    @PostConstruct
    private void createControl() {
        super.createPartControl(this.parent);
        this.subscribe();
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        super.setFocus();
        this.updatePeakTargets(this.peak, false);
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandlerChromatogramSelection = new EventHandler(){

                public void handleEvent(Event event) {
                    IChromatogramSelectionCSD chromatogramSelection = (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    if (chromatogramSelection != null) {
                        PeakTargetsView.this.peak = (IPeakCSD)chromatogramSelection.getSelectedPeak();
                        PeakTargetsView.this.updatePeakTargets(PeakTargetsView.this.peak, forceReload);
                    }
                }
            };
            this.eventBroker.subscribe("chromatogram/csd/update/chromatogramselection", this.eventHandlerChromatogramSelection);
            this.eventHandlerPeak = new EventHandler(){

                public void handleEvent(Event event) {
                    PeakTargetsView.this.peak = (IPeakCSD)event.getProperty("PeakCSD");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    PeakTargetsView.this.updatePeakTargets(PeakTargetsView.this.peak, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/csd/update/peak", this.eventHandlerPeak);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null) {
            if (this.eventHandlerChromatogramSelection != null) {
                this.eventBroker.unsubscribe(this.eventHandlerChromatogramSelection);
            }
            if (this.eventHandlerPeak != null) {
                this.eventBroker.unsubscribe(this.eventHandlerPeak);
            }
        }
    }

    private boolean doUpdate(IPeakCSD peak) {
        return this.isPartVisible() && peak != null;
    }

    private boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    private void updatePeakTargets(IPeakCSD peak, boolean forceReload) {
        if (this.doUpdate(peak)) {
            super.update((Object)peak, forceReload);
        }
    }
}

