/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.wsd.ui.views;

import org.eclipse.chemclipse.ux.extension.ui.definitions.ChromatogramType;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.chemclipse.ux.extension.wsd.ui.views.IChromatogramSelectionWSDView;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractChromatogramSelectionWSDView
extends AbstractSelectionView
implements IChromatogramSelectionWSDView {
    private IChromatogramSelectionWSD chromatogramSelection;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractChromatogramSelectionWSDView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IChromatogramSelectionWSD getChromatogramSelection() {
        if (this.chromatogramSelection == null) {
            this.chromatogramSelection = ChromatogramType.getChromatogramSelectionWSD();
        }
        return this.chromatogramSelection;
    }

    @Override
    public void setChromatogramSelection(IChromatogramSelectionWSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    AbstractChromatogramSelectionWSDView.this.chromatogramSelection = (IChromatogramSelectionWSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    AbstractChromatogramSelectionWSDView.this.update(AbstractChromatogramSelectionWSDView.this.chromatogramSelection, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/wsd/update/chromatogramselection", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

