/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.core;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.combined.AbstractCombinedIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.combined.ICombinedIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.ValueMustNotBeNullException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.CombinedIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.ICombinedIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.CombinedIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.ICombinedIntegrationResult;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IPeakIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support.TrapezoidChromatogramIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.internal.support.TrapezoidPeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class CombinedIntegrator
extends AbstractCombinedIntegrator {
    private static final Logger logger = Logger.getLogger(CombinedIntegrator.class);
    private ICombinedIntegrationSettings combinedIntegrationSettings;

    public ICombinedIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, ICombinedIntegrationSettings combinedIntegrationSettings, IProgressMonitor monitor) {
        CombinedIntegratorProcessingInfo processingInfo = new CombinedIntegratorProcessingInfo();
        try {
            this.validate(chromatogramSelection, combinedIntegrationSettings);
            TrapezoidPeakIntegratorSupport firstDerivativePeakIntegratorSupport = new TrapezoidPeakIntegratorSupport();
            IPeakIntegrationResults peakIntegrationResults = firstDerivativePeakIntegratorSupport.calculatePeakIntegrationResults(chromatogramSelection, combinedIntegrationSettings.getPeakIntegrationSettings(), monitor);
            TrapezoidChromatogramIntegratorSupport firstDerivativeChromatogramIntegratorSupport = new TrapezoidChromatogramIntegratorSupport();
            IChromatogramIntegrationResults chromatogramIntegrationResults = firstDerivativeChromatogramIntegratorSupport.calculateChromatogramIntegrationResults(chromatogramSelection, combinedIntegrationSettings.getChromatogramIntegrationSettings(), monitor);
            CombinedIntegrationResult combinedIntegrationResult = new CombinedIntegrationResult(chromatogramIntegrationResults, peakIntegrationResults);
            processingInfo.setCombinedIntegrationResult((ICombinedIntegrationResult)combinedIntegrationResult);
        }
        catch (ValueMustNotBeNullException e) {
            logger.warn((Object)e);
            this.addIntegratorExceptionInfo((IProcessingInfo)processingInfo);
        }
        return processingInfo;
    }

    public ICombinedIntegrationSettings getCombinedIntegrationSettings() {
        return this.combinedIntegrationSettings;
    }

    public CombinedIntegrator setCombinedIntegrationSettings(ICombinedIntegrationSettings combinedIntegrationSettings) {
        this.combinedIntegrationSettings = combinedIntegrationSettings;
        return this;
    }

    public ICombinedIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        if (this.combinedIntegrationSettings == null) {
            this.combinedIntegrationSettings = PreferenceSupplier.getCombinedIntegrationSettings();
        }
        return this.integrate(chromatogramSelection, this.combinedIntegrationSettings, monitor);
    }

    private void addIntegratorExceptionInfo(IProcessingInfo processingInfo) {
        processingInfo.addErrorMessage("Combined Integrator Trapezoid", "The peak(s) or settings couldn't be validated correctly.");
    }
}

