/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.text.DecimalFormat;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.internal.widgets.introspection.Introspectable;
import org.eclipse.nebula.visualization.internal.widgets.introspection.ScaleWidgetIntrospector;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;

public abstract class AbstractScaledWidgetFigure
extends Figure
implements Introspectable {
    protected AbstractScale scale;
    protected boolean transparent = true;
    protected double value = 50.0;
    protected double minimum = 0.0;
    protected double maximum = 100.0;
    protected int majorTickMarkStepHint = 30;
    protected boolean showMinorTicks = true;
    protected boolean showScale = true;
    protected boolean logScale = false;
    protected String valueLabelFormat = "";

    @Override
    public BeanInfo getBeanInfo() throws IntrospectionException {
        return new ScaleWidgetIntrospector().getBeanInfo(this.getClass());
    }

    public double getCoercedValue() {
        return this.getCoercedValue(this.value);
    }

    public double getCoercedValue(double v) {
        Range range = this.scale.getRange();
        if (range.inRange(v)) {
            return v;
        }
        if (range.getUpper() >= range.getLower()) {
            return v > range.getUpper() ? range.getUpper() : range.getLower();
        }
        return v > range.getLower() ? range.getLower() : range.getUpper();
    }

    public int getMajorTickMarkStepHint() {
        return this.majorTickMarkStepHint;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public Range getRange() {
        return new Range(this.minimum, this.maximum);
    }

    public AbstractScale getScale() {
        return this.scale;
    }

    public double getValue() {
        return this.value;
    }

    public String getValueLabelFormat() {
        return this.valueLabelFormat;
    }

    public String getValueText() {
        if (this.valueLabelFormat.trim().equals("")) {
            return this.getScale().format((Object)this.getValue());
        }
        return new DecimalFormat(this.valueLabelFormat).format(this.getValue());
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public boolean isOpaque() {
        return false;
    }

    public boolean isShowMinorTicks() {
        return this.showMinorTicks;
    }

    public boolean isShowScale() {
        return this.showScale;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void paintFigure(Graphics graphics) {
        if (!this.transparent) {
            graphics.setBackgroundColor(this.getBackgroundColor());
            Rectangle bounds = this.getBounds().getCopy();
            bounds.crop(this.getInsets());
            graphics.fillRectangle(bounds);
        }
        super.paintFigure(graphics);
    }

    public void setLogScale(boolean logScale) {
        if (this.logScale == logScale) {
            return;
        }
        this.logScale = logScale;
        this.scale.setLogScale(logScale);
        this.scale.setRange(new Range(this.minimum, this.maximum));
        this.repaint();
    }

    public void setMajorTickMarkStepHint(int majorTickMarkStepHint) {
        if (this.majorTickMarkStepHint == majorTickMarkStepHint || majorTickMarkStepHint <= 0) {
            return;
        }
        this.majorTickMarkStepHint = majorTickMarkStepHint;
        this.scale.setMajorTickMarkStepHint(majorTickMarkStepHint);
        this.repaint();
    }

    public void setRange(double min, double max) {
        this.scale.setRange(min, max);
        this.maximum = this.scale.getRange().getUpper();
        this.minimum = this.scale.getRange().getLower();
        this.repaint();
    }

    public void setRange(Range range) {
        this.setRange(range.getLower(), range.getUpper());
    }

    public void setScale(AbstractScale scale) {
        this.scale = scale;
    }

    public void setShowMinorTicks(boolean showMinorTicks) {
        if (this.showMinorTicks == showMinorTicks) {
            return;
        }
        this.showMinorTicks = showMinorTicks;
        this.scale.setMinorTicksVisible(showMinorTicks);
        this.repaint();
    }

    public void setShowScale(boolean showScale) {
        if (this.showScale == showScale) {
            return;
        }
        this.showScale = showScale;
        this.scale.setVisible(showScale);
        this.repaint();
    }

    public void setTransparent(boolean transparent) {
        if (this.transparent == transparent) {
            return;
        }
        this.transparent = transparent;
        this.repaint();
    }

    public void setValue(double value) {
        this.value = value;
        this.repaint();
    }

    public void setValueLabelFormat(String valueLabelFormat) {
        try {
            new DecimalFormat(valueLabelFormat);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        this.valueLabelFormat = valueLabelFormat;
        this.setValue(this.value);
    }
}

