/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.io.AbstractReaderVersion;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.v20.model.MsRun;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.v20.model.Peaks;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.v20.model.Scan;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.model.VendorChromatogram;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.model.VendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.model.VendorScan;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReaderVersion20
extends AbstractReaderVersion
implements IChromatogramMSDReader {
    private static final Logger logger = Logger.getLogger(ReaderVersion20.class);
    private static final int ION_PRECISION = 4;
    private String contextPath;

    public ReaderVersion20(String contextPath) {
        this.contextPath = contextPath;
    }

    public IChromatogramMSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        VendorChromatogram chromatogram = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("msRun");
            JAXBContext jaxbContext = JAXBContext.newInstance((String)this.contextPath);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            MsRun msrun = (MsRun)unmarshaller.unmarshal(nodeList.item(0));
            chromatogram = new VendorChromatogram();
            for (Scan scan : msrun.getScan()) {
                int index;
                double[] values;
                VendorScan massSpectrum = new VendorScan();
                int retentionTime = scan.getRetentionTime().multiply(1000).getSeconds();
                massSpectrum.setRetentionTime(retentionTime);
                Peaks peaks = scan.getPeaks();
                ByteBuffer byteBuffer = ByteBuffer.wrap(peaks.getValue());
                String byteOrder = peaks.getByteOrder();
                if (byteOrder != null && byteOrder.equals("network")) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                } else {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                BigInteger precision = peaks.getPrecision();
                if (precision != null && precision.intValue() == 64) {
                    DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                    values = new double[doubleBuffer.capacity()];
                    index = 0;
                    while (index < doubleBuffer.capacity()) {
                        values[index] = new Double(doubleBuffer.get(index));
                        ++index;
                    }
                } else {
                    FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
                    values = new double[floatBuffer.capacity()];
                    index = 0;
                    while (index < floatBuffer.capacity()) {
                        values[index] = new Double(floatBuffer.get(index));
                        ++index;
                    }
                }
                int peakIndex = 0;
                while (peakIndex < values.length - 1) {
                    double mz = AbstractIon.getIon((double)values[peakIndex], (int)4);
                    float intensity = (float)values[peakIndex + 1];
                    try {
                        if (intensity >= Float.MIN_VALUE && intensity <= Float.MAX_VALUE) {
                            VendorIon ion = new VendorIon(mz, intensity);
                            massSpectrum.addIon((IIon)ion);
                        }
                    }
                    catch (AbundanceLimitExceededException e) {
                        logger.warn((Object)e);
                    }
                    catch (IonLimitExceededException e) {
                        logger.warn((Object)e);
                    }
                    peakIndex += 2;
                }
                chromatogram.addScan((IScan)massSpectrum);
            }
        }
        catch (SAXException e) {
            logger.warn((Object)e);
        }
        catch (JAXBException e) {
            logger.warn((Object)e);
        }
        catch (ParserConfigurationException e) {
            logger.warn((Object)e);
        }
        chromatogram.setConverterId("");
        chromatogram.setFile(file);
        return chromatogram;
    }
}

