/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.chemclipse.support.runtime.IRuntimeSupport;

public abstract class AbstractRuntimeSupport
implements IRuntimeSupport {
    private String application = "";
    private String path = "";
    private String executable = "";
    private String parameter = "";

    public AbstractRuntimeSupport(String application, String parameter) throws FileNotFoundException {
        try {
            File file = new File(application);
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            this.application = application;
            this.path = file.getParent();
            this.executable = application.replace(String.valueOf(this.path) + File.separator, "");
        }
        catch (Exception exception) {
            throw new FileNotFoundException();
        }
        if (parameter != null) {
            this.parameter = parameter;
        }
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    @Override
    public String getApplicationPath() {
        return this.path;
    }

    @Override
    public String getApplicationExecutable() {
        return this.executable;
    }

    @Override
    public int getSleepMillisecondsBeforeExecuteRunCommand() {
        return 1000;
    }
}

