/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.quantitation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.msd.model.core.IIntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;

public class IntegrationQuantitationSupport {
    private static final Logger logger = Logger.getLogger(IntegrationQuantitationSupport.class);
    private IPeakMSD peak;
    private Map<Double, Double> integratedIons;

    public IntegrationQuantitationSupport(IPeakMSD peak) {
        this.peak = peak;
        this.integratedIons = this.getListOfIntegratedIons();
    }

    public boolean validateTIC() {
        if (this.isTheTotalSignalIntegrated()) {
            return true;
        }
        logger.warn((Object)("Quantitation: The peak integration entry doesn't match: " + this.peak));
        return false;
    }

    public boolean validateXIC(List<Double> selectedQuantitationIons) {
        if (this.isTheTotalSignalIntegrated()) {
            return true;
        }
        if (this.integratedIons.keySet().containsAll(selectedQuantitationIons)) {
            return true;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Quantitation: The peak integration entries do not match quantitation entries: ");
        builder.append(this.peak);
        builder.append(" Integrated Ions: ");
        builder.append(this.integratedIons);
        builder.append(" Selected Quantitation Ions: ");
        builder.append(selectedQuantitationIons);
        logger.warn((Object)builder.toString());
        return false;
    }

    public boolean isTheTotalSignalIntegrated() {
        return this.integratedIons.size() == 1 && this.integratedIons.containsKey(0.0);
    }

    public double getIntegrationArea(double ion) {
        Double value = this.isTheTotalSignalIntegrated() ? this.integratedIons.get(0.0) : this.integratedIons.get(ion);
        return value == null ? 0.0 : value;
    }

    private Map<Double, Double> getListOfIntegratedIons() {
        HashMap<Double, Double> integratedIons = new HashMap<Double, Double>();
        for (IIntegrationEntry entry : this.peak.getIntegrationEntries()) {
            if (!(entry instanceof IIntegrationEntryMSD)) continue;
            IIntegrationEntryMSD integrationEntry = (IIntegrationEntryMSD)entry;
            double key = integrationEntry.getIon();
            double value = integrationEntry.getIntegratedArea();
            integratedIons.put(key, value);
        }
        return integratedIons;
    }
}

