/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.xic;

import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignals;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;

public class ExtractedIonSignalExtractor
implements IExtractedIonSignalExtractor {
    private IChromatogramMSD chromatogram;

    public ExtractedIonSignalExtractor(IChromatogramMSD chromatogram) throws ChromatogramIsNullException {
        if (chromatogram == null) {
            throw new ChromatogramIsNullException();
        }
        this.chromatogram = chromatogram;
    }

    @Override
    public IExtractedIonSignals getExtractedIonSignals(float startIon, float stopIon) {
        ExtractedIonSignals signals = new ExtractedIonSignals(this.chromatogram.getNumberOfScans(), this.chromatogram);
        for (IScan scan : this.chromatogram.getScans()) {
            if (!(scan instanceof IVendorMassSpectrum)) continue;
            IVendorMassSpectrum ms = (IVendorMassSpectrum)scan;
            IExtractedIonSignal extractedIonSignal = ms.getExtractedIonSignal(startIon, stopIon);
            signals.add(extractedIonSignal);
        }
        return signals;
    }

    @Override
    public IExtractedIonSignals getExtractedIonSignals() {
        ExtractedIonSignals signals = new ExtractedIonSignals(this.chromatogram.getNumberOfScans(), this.chromatogram);
        for (IScan scan : this.chromatogram.getScans()) {
            if (!(scan instanceof IVendorMassSpectrum)) continue;
            IVendorMassSpectrum ms = (IVendorMassSpectrum)scan;
            IExtractedIonSignal extractedIonSignal = ms.getExtractedIonSignal();
            signals.add(extractedIonSignal);
        }
        return signals;
    }

    @Override
    public IExtractedIonSignals getExtractedIonSignals(IChromatogramSelectionMSD chromatogramSelection) {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() != this.chromatogram) {
            return new ExtractedIonSignals(0, this.chromatogram);
        }
        int startScan = this.chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = this.chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        return this.getExtractedIonSignals(startScan, stopScan);
    }

    @Override
    public IExtractedIonSignals getExtractedIonSignals(int startScan, int stopScan) {
        if (startScan > stopScan) {
            int tmp = startScan;
            startScan = stopScan;
            stopScan = tmp;
        }
        if (startScan < 1 && stopScan > this.chromatogram.getNumberOfScans()) {
            return new ExtractedIonSignals(0, this.chromatogram);
        }
        ExtractedIonSignals extractedIonSignals = new ExtractedIonSignals(startScan, stopScan, this.chromatogram);
        int scan = startScan;
        while (scan <= stopScan) {
            IVendorMassSpectrum supplierMassSpectrum = this.chromatogram.getSupplierScan(scan);
            extractedIonSignals.add(supplierMassSpectrum.getExtractedIonSignal());
            ++scan;
        }
        return extractedIonSignals;
    }
}

