/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.core;

import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.core.AbstractSumareaIntegrator;
import org.eclipse.chemclipse.chromatogram.msd.integrator.supplier.sumarea.internal.core.ISumareaIntegrator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;

public class ChromatogramIntegrator
extends AbstractSumareaIntegrator
implements ISumareaIntegrator {
    private static final Logger logger = Logger.getLogger(ChromatogramIntegrator.class);

    @Override
    public double integrate(IChromatogramSelectionMSD chromatogramSelection) {
        return this.integrate(chromatogramSelection, 0);
    }

    @Override
    public double integrate(IChromatogramSelectionMSD chromatogramSelection, int ion) {
        double chromatogramArea = 0.0;
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        try {
            ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
            IExtractedIonSignals extractedIonSignals = extractedIonSignalExtractor.getExtractedIonSignals(chromatogramSelection);
            int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
            double segmentArea = 0.0;
            int scan = startScan;
            while (scan < stopScan) {
                try {
                    IExtractedIonSignal startSignal = extractedIonSignals.getExtractedIonSignal(scan);
                    IExtractedIonSignal stopSignal = extractedIonSignals.getExtractedIonSignal(scan + 1);
                    if (startSignal != null && stopSignal != null) {
                        float startAbundance = startSignal.getAbundance(ion);
                        float stopAbundance = stopSignal.getAbundance(ion);
                        segmentArea = this.calculateArea(startSignal.getRetentionTime(), stopSignal.getRetentionTime(), startAbundance, stopAbundance);
                        chromatogramArea += segmentArea;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
                ++scan;
            }
        }
        catch (ChromatogramIsNullException e1) {
            logger.warn((Object)e1);
        }
        return chromatogramArea;
    }
}

