/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Arrays;
import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decompose.lu.LUDecompositionAlt_CD64;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.alg.dense.misc.CTransposeAlgs;
import org.ejml.alg.dense.mult.CMatrixMatrixMult;
import org.ejml.data.CD1Matrix64F;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.CLinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;

public class CCommonOps {
    public static CDenseMatrix64F identity(int width) {
        CDenseMatrix64F A = new CDenseMatrix64F(width, width);
        int i = 0;
        while (i < width) {
            A.set(i, i, 1.0, 0.0);
            ++i;
        }
        return A;
    }

    public static CDenseMatrix64F identity(int width, int height) {
        CDenseMatrix64F A = new CDenseMatrix64F(width, height);
        int m = Math.min(width, height);
        int i = 0;
        while (i < m) {
            A.set(i, i, 1.0, 0.0);
            ++i;
        }
        return A;
    }

    public static CDenseMatrix64F diag(double ... data) {
        if (data.length % 2 == 1) {
            throw new IllegalArgumentException("must be an even number of arguments");
        }
        int N = data.length / 2;
        CDenseMatrix64F m = new CDenseMatrix64F(N, N);
        int index = 0;
        int i = 0;
        while (i < N) {
            m.set(i, i, data[index++], data[index++]);
            ++i;
        }
        return m;
    }

    public static void convert(D1Matrix64F input, CD1Matrix64F output) {
        if (input.numCols != output.numCols || input.numRows != output.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        Arrays.fill(output.data, 0, output.getDataLength(), 0.0);
        int length = output.getDataLength();
        int i = 0;
        while (i < length) {
            output.data[i] = input.data[i / 2];
            i += 2;
        }
    }

    public static DenseMatrix64F stripReal(CD1Matrix64F input, DenseMatrix64F output) {
        if (output == null) {
            output = new DenseMatrix64F(input.numRows, input.numCols);
        } else if (input.numCols != output.numCols || input.numRows != output.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int length = input.getDataLength();
        int i = 0;
        while (i < length) {
            output.data[i / 2] = input.data[i];
            i += 2;
        }
        return output;
    }

    public static DenseMatrix64F stripImaginary(CD1Matrix64F input, DenseMatrix64F output) {
        if (output == null) {
            output = new DenseMatrix64F(input.numRows, input.numCols);
        } else if (input.numCols != output.numCols || input.numRows != output.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int length = input.getDataLength();
        int i = 1;
        while (i < length) {
            output.data[i / 2] = input.data[i];
            i += 2;
        }
        return output;
    }

    public static void magnitude(CD1Matrix64F input, D1Matrix64F output) {
        if (input.numCols != output.numCols || input.numRows != output.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int length = input.getDataLength();
        int i = 0;
        while (i < length) {
            double real = input.data[i];
            double imaginary = input.data[i + 1];
            output.data[i / 2] = Math.sqrt(real * real + imaginary * imaginary);
            i += 2;
        }
    }

    public static void conjugate(CD1Matrix64F input, CD1Matrix64F output) {
        if (input.numCols != output.numCols || input.numRows != output.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int length = input.getDataLength();
        int i = 0;
        while (i < length) {
            output.data[i] = input.data[i];
            output.data[i + 1] = -input.data[i + 1];
            i += 2;
        }
    }

    public static void fill(CD1Matrix64F a, double real, double imaginary) {
        int N = a.getDataLength();
        int i = 0;
        while (i < N) {
            a.data[i] = real;
            a.data[i + 1] = imaginary;
            i += 2;
        }
    }

    public static void add(CD1Matrix64F a, CD1Matrix64F b, CD1Matrix64F c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows || a.numCols != c.numCols || a.numRows != c.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int length = a.getDataLength();
        int i = 0;
        while (i < length) {
            c.data[i] = a.data[i] + b.data[i];
            ++i;
        }
    }

    public static void subtract(CD1Matrix64F a, CD1Matrix64F b, CD1Matrix64F c) {
        if (a.numCols != b.numCols || a.numRows != b.numRows || a.numCols != c.numCols || a.numRows != c.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int length = a.getDataLength();
        int i = 0;
        while (i < length) {
            c.data[i] = a.data[i] - b.data[i];
            ++i;
        }
    }

    public static void mult(CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (b.numCols >= EjmlParameters.CMULT_COLUMN_SWITCH) {
            CMatrixMatrixMult.mult_reorder(a, b, c);
        } else {
            CMatrixMatrixMult.mult_small(a, b, c);
        }
    }

    public static void mult(double realAlpha, double imgAlpha, CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (b.numCols >= EjmlParameters.CMULT_COLUMN_SWITCH) {
            CMatrixMatrixMult.mult_reorder(realAlpha, imgAlpha, a, b, c);
        } else {
            CMatrixMatrixMult.mult_small(realAlpha, imgAlpha, a, b, c);
        }
    }

    public static void multAdd(CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (b.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            CMatrixMatrixMult.multAdd_reorder(a, b, c);
        } else {
            CMatrixMatrixMult.multAdd_small(a, b, c);
        }
    }

    public static void multAdd(double realAlpha, double imgAlpha, CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F c) {
        if (b.numCols >= EjmlParameters.CMULT_COLUMN_SWITCH) {
            CMatrixMatrixMult.multAdd_reorder(realAlpha, imgAlpha, a, b, c);
        } else {
            CMatrixMatrixMult.multAdd_small(realAlpha, imgAlpha, a, b, c);
        }
    }

    public static void transpose(CDenseMatrix64F mat) {
        if (mat.numCols == mat.numRows) {
            CTransposeAlgs.square(mat);
        } else {
            CDenseMatrix64F b = new CDenseMatrix64F(mat.numCols, mat.numRows);
            CCommonOps.transpose(mat, b);
            mat.reshape(b.numRows, b.numCols);
            mat.set(b);
        }
    }

    public static void transposeConjugate(CDenseMatrix64F mat) {
        if (mat.numCols == mat.numRows) {
            CTransposeAlgs.squareConjugate(mat);
        } else {
            CDenseMatrix64F b = new CDenseMatrix64F(mat.numCols, mat.numRows);
            CCommonOps.transposeConjugate(mat, b);
            mat.reshape(b.numRows, b.numCols);
            mat.set(b);
        }
    }

    public static CDenseMatrix64F transpose(CDenseMatrix64F input, CDenseMatrix64F output) {
        if (output == null) {
            output = new CDenseMatrix64F(input.numCols, input.numRows);
        } else if (input.numCols != output.numRows || input.numRows != output.numCols) {
            throw new IllegalArgumentException("Input and output shapes are not compatible");
        }
        CTransposeAlgs.standard(input, output);
        return output;
    }

    public static CDenseMatrix64F transposeConjugate(CDenseMatrix64F input, CDenseMatrix64F output) {
        if (output == null) {
            output = new CDenseMatrix64F(input.numCols, input.numRows);
        } else if (input.numCols != output.numRows || input.numRows != output.numCols) {
            throw new IllegalArgumentException("Input and output shapes are not compatible");
        }
        CTransposeAlgs.standardConjugate(input, output);
        return output;
    }

    public static boolean invert(CDenseMatrix64F A) {
        LinearSolver<CDenseMatrix64F> solver = CLinearSolverFactory.lu(A.numRows);
        if (!solver.setA(A)) {
            return false;
        }
        solver.invert(A);
        return true;
    }

    public static boolean invert(CDenseMatrix64F input, CDenseMatrix64F output) {
        LinearSolver<CDenseMatrix64F> solver = CLinearSolverFactory.lu(input.numRows);
        if (solver.modifiesA()) {
            input = input.copy();
        }
        if (!solver.setA(input)) {
            return false;
        }
        solver.invert(output);
        return true;
    }

    public static boolean solve(CDenseMatrix64F a, CDenseMatrix64F b, CDenseMatrix64F x) {
        LinearSolver<CDenseMatrix64F> solver = a.numCols == a.numRows ? CLinearSolverFactory.lu(a.numRows) : CLinearSolverFactory.qr(a.numRows, a.numCols);
        if (!(solver = new LinearSolverSafe<CDenseMatrix64F>(solver)).setA(a)) {
            return false;
        }
        solver.solve(b, x);
        return true;
    }

    public static Complex64F det(CDenseMatrix64F mat) {
        LUDecompositionAlt_CD64 alg = new LUDecompositionAlt_CD64();
        if (alg.inputModified()) {
            mat = mat.copy();
        }
        if (!alg.decompose(mat)) {
            return new Complex64F();
        }
        return alg.computeDeterminant();
    }

    public static void elementMultiply(CD1Matrix64F input, double real, double imaginary, CD1Matrix64F output) {
        if (input.numCols != output.numCols || input.numRows != output.numRows) {
            throw new IllegalArgumentException("The 'input' and 'output' matrices do not have compatible dimensions");
        }
        int N = input.getDataLength();
        int i = 0;
        while (i < N) {
            double inReal = input.data[i];
            double intImag = input.data[i + 1];
            output.data[i] = inReal * real - intImag * imaginary;
            output.data[i + 1] = inReal * imaginary + intImag * real;
            i += 2;
        }
    }

    public static void elementDivide(CD1Matrix64F input, double real, double imaginary, CD1Matrix64F output) {
        if (input.numCols != output.numCols || input.numRows != output.numRows) {
            throw new IllegalArgumentException("The 'input' and 'output' matrices do not have compatible dimensions");
        }
        double norm = real * real + imaginary * imaginary;
        int N = input.getDataLength();
        int i = 0;
        while (i < N) {
            double inReal = input.data[i];
            double inImag = input.data[i + 1];
            output.data[i] = (inReal * real + inImag * imaginary) / norm;
            output.data[i + 1] = (inImag * real - inReal * imaginary) / norm;
            i += 2;
        }
    }

    public static void elementDivide(double real, double imaginary, CD1Matrix64F input, CD1Matrix64F output) {
        if (input.numCols != output.numCols || input.numRows != output.numRows) {
            throw new IllegalArgumentException("The 'input' and 'output' matrices do not have compatible dimensions");
        }
        int N = input.getDataLength();
        int i = 0;
        while (i < N) {
            double inReal = input.data[i];
            double inImag = input.data[i + 1];
            double norm = inReal * inReal + inImag * inImag;
            output.data[i] = (real * inReal + imaginary * inImag) / norm;
            output.data[i + 1] = (imaginary * inReal - real * inImag) / norm;
            i += 2;
        }
    }

    public static double elementMinReal(CD1Matrix64F a) {
        int size = a.getDataLength();
        double min = a.data[0];
        int i = 2;
        while (i < size) {
            double val = a.data[i];
            if (val < min) {
                min = val;
            }
            i += 2;
        }
        return min;
    }

    public static double elementMinImaginary(CD1Matrix64F a) {
        int size = a.getDataLength();
        double min = a.data[1];
        int i = 3;
        while (i < size) {
            double val = a.data[i];
            if (val < min) {
                min = val;
            }
            i += 2;
        }
        return min;
    }

    public static double elementMaxReal(CD1Matrix64F a) {
        int size = a.getDataLength();
        double max = a.data[0];
        int i = 2;
        while (i < size) {
            double val = a.data[i];
            if (val > max) {
                max = val;
            }
            i += 2;
        }
        return max;
    }

    public static double elementMaxImaginary(CD1Matrix64F a) {
        int size = a.getDataLength();
        double max = a.data[1];
        int i = 3;
        while (i < size) {
            double val = a.data[i];
            if (val > max) {
                max = val;
            }
            i += 2;
        }
        return max;
    }

    public static double elementMaxMagnitude2(CD1Matrix64F a) {
        int size = a.getDataLength();
        double max = 0.0;
        int i = 0;
        while (i < size) {
            double real = a.data[i++];
            int n = i++;
            double imaginary = a.data[n];
            double m = real * real + imaginary * imaginary;
            if (!(m > max)) continue;
            max = m;
        }
        return max;
    }

    public static void setIdentity(CDenseMatrix64F mat) {
        int width = mat.numRows < mat.numCols ? mat.numRows : mat.numCols;
        Arrays.fill(mat.data, 0, mat.getDataLength(), 0.0);
        int index = 0;
        int stride = mat.getRowStride();
        int i = 0;
        while (i < width) {
            mat.data[index] = 1.0;
            ++i;
            index += stride + 2;
        }
    }

    public static CDenseMatrix64F extract(CDenseMatrix64F src, int srcY0, int srcY1, int srcX0, int srcX1) {
        if (srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows) {
            throw new IllegalArgumentException("srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows");
        }
        if (srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols) {
            throw new IllegalArgumentException("srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols");
        }
        int w = srcX1 - srcX0;
        int h = srcY1 - srcY0;
        CDenseMatrix64F dst = new CDenseMatrix64F(h, w);
        CCommonOps.extract(src, srcY0, srcY1, srcX0, srcX1, dst, 0, 0);
        return dst;
    }

    public static void extract(CDenseMatrix64F src, int srcY0, int srcY1, int srcX0, int srcX1, CDenseMatrix64F dst, int dstY0, int dstX0) {
        int numRows = srcY1 - srcY0;
        int stride = (srcX1 - srcX0) * 2;
        int y = 0;
        while (y < numRows) {
            int indexSrc = src.getIndex(y + srcY0, srcX0);
            int indexDst = dst.getIndex(y + dstY0, dstX0);
            System.arraycopy(src.data, indexSrc, dst.data, indexDst, stride);
            ++y;
        }
    }

    public static CDenseMatrix64F[] columnsToVector(CDenseMatrix64F A, CDenseMatrix64F[] v) {
        CDenseMatrix64F[] ret = v == null || v.length < A.numCols ? new CDenseMatrix64F[A.numCols] : v;
        int i = 0;
        while (i < ret.length) {
            if (ret[i] == null) {
                ret[i] = new CDenseMatrix64F(A.numRows, 1);
            } else {
                ret[i].reshape(A.numRows, 1);
            }
            CDenseMatrix64F u = ret[i];
            int indexU = 0;
            int j = 0;
            while (j < A.numRows) {
                int indexA = A.getIndex(j, i);
                u.data[indexU++] = A.data[indexA++];
                u.data[indexU++] = A.data[indexA];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static double elementMaxAbs(CDenseMatrix64F a) {
        int size = a.getDataLength();
        double max = 0.0;
        int i = 0;
        while (i < size) {
            double real = a.data[i];
            double imag = a.data[i + 1];
            double val = real * real + imag * imag;
            if (val > max) {
                max = val;
            }
            i += 2;
        }
        return Math.sqrt(max);
    }
}

