/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.correlation;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;

public class KendallsCorrelation {
    private final RealMatrix correlationMatrix;

    public KendallsCorrelation() {
        this.correlationMatrix = null;
    }

    public KendallsCorrelation(double[][] data) {
        this(MatrixUtils.createRealMatrix(data));
    }

    public KendallsCorrelation(RealMatrix matrix) {
        this.correlationMatrix = this.computeCorrelationMatrix(matrix);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix matrix) {
        int nVars = matrix.getColumnDimension();
        BlockRealMatrix outMatrix = new BlockRealMatrix(nVars, nVars);
        int i = 0;
        while (i < nVars) {
            int j = 0;
            while (j < i) {
                double corr = this.correlation(matrix.getColumn(i), matrix.getColumn(j));
                outMatrix.setEntry(i, j, corr);
                outMatrix.setEntry(j, i, corr);
                ++j;
            }
            outMatrix.setEntry(i, i, 1.0);
            ++i;
        }
        return outMatrix;
    }

    public RealMatrix computeCorrelationMatrix(double[][] matrix) {
        return this.computeCorrelationMatrix(new BlockRealMatrix(matrix));
    }

    public double correlation(double[] xArray, double[] yArray) throws DimensionMismatchException {
        if (xArray.length != yArray.length) {
            throw new DimensionMismatchException(xArray.length, yArray.length);
        }
        int n = xArray.length;
        long numPairs = KendallsCorrelation.sum(n - 1);
        Pair[] pairs = new Pair[n];
        int i = 0;
        while (i < n) {
            pairs[i] = new Pair<Double, Double>(xArray[i], yArray[i]);
            ++i;
        }
        Arrays.sort(pairs, new Comparator<Pair<Double, Double>>(){

            @Override
            public int compare(Pair<Double, Double> pair1, Pair<Double, Double> pair2) {
                int compareFirst = pair1.getFirst().compareTo(pair2.getFirst());
                return compareFirst != 0 ? compareFirst : pair1.getSecond().compareTo(pair2.getSecond());
            }
        });
        long tiedXPairs = 0L;
        long tiedXYPairs = 0L;
        long consecutiveXTies = 1L;
        long consecutiveXYTies = 1L;
        Pair prev = pairs[0];
        int i2 = 1;
        while (i2 < n) {
            Pair curr = pairs[i2];
            if (((Double)curr.getFirst()).equals(prev.getFirst())) {
                ++consecutiveXTies;
                if (((Double)curr.getSecond()).equals(prev.getSecond())) {
                    ++consecutiveXYTies;
                } else {
                    tiedXYPairs += KendallsCorrelation.sum(consecutiveXYTies - 1L);
                    consecutiveXYTies = 1L;
                }
            } else {
                tiedXPairs += KendallsCorrelation.sum(consecutiveXTies - 1L);
                consecutiveXTies = 1L;
                tiedXYPairs += KendallsCorrelation.sum(consecutiveXYTies - 1L);
                consecutiveXYTies = 1L;
            }
            prev = curr;
            ++i2;
        }
        tiedXPairs += KendallsCorrelation.sum(consecutiveXTies - 1L);
        tiedXYPairs += KendallsCorrelation.sum(consecutiveXYTies - 1L);
        int swaps = 0;
        Pair[] pairsDestination = new Pair[n];
        int segmentSize = 1;
        while (segmentSize < n) {
            int offset = 0;
            while (offset < n) {
                int iEnd;
                int i3 = offset;
                int j = iEnd = FastMath.min(i3 + segmentSize, n);
                int jEnd = FastMath.min(j + segmentSize, n);
                int copyLocation = offset;
                while (i3 < iEnd || j < jEnd) {
                    if (i3 < iEnd) {
                        if (j < jEnd) {
                            if (((Double)pairs[i3].getSecond()).compareTo((Double)pairs[j].getSecond()) <= 0) {
                                pairsDestination[copyLocation] = pairs[i3];
                                ++i3;
                            } else {
                                pairsDestination[copyLocation] = pairs[j];
                                ++j;
                                swaps += iEnd - i3;
                            }
                        } else {
                            pairsDestination[copyLocation] = pairs[i3];
                            ++i3;
                        }
                    } else {
                        pairsDestination[copyLocation] = pairs[j];
                        ++j;
                    }
                    ++copyLocation;
                }
                offset += 2 * segmentSize;
            }
            Pair[] pairsTemp = pairs;
            pairs = pairsDestination;
            pairsDestination = pairsTemp;
            segmentSize <<= 1;
        }
        long tiedYPairs = 0L;
        long consecutiveYTies = 1L;
        prev = pairs[0];
        int i4 = 1;
        while (i4 < n) {
            Pair curr = pairs[i4];
            if (((Double)curr.getSecond()).equals(prev.getSecond())) {
                ++consecutiveYTies;
            } else {
                tiedYPairs += KendallsCorrelation.sum(consecutiveYTies - 1L);
                consecutiveYTies = 1L;
            }
            prev = curr;
            ++i4;
        }
        long concordantMinusDiscordant = numPairs - tiedXPairs - (tiedYPairs += KendallsCorrelation.sum(consecutiveYTies - 1L)) + tiedXYPairs - (long)(2 * swaps);
        double nonTiedPairsMultiplied = (double)(numPairs - tiedXPairs) * (double)(numPairs - tiedYPairs);
        return (double)concordantMinusDiscordant / FastMath.sqrt(nonTiedPairsMultiplied);
    }

    private static long sum(long n) {
        return n * (n + 1L) / 2L;
    }
}

