/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.core;

import org.eclipse.chemclipse.chromatogram.msd.peak.detector.core.IPeakDetectorMSD;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.processing.IPeakDetectorMSDProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.processing.PeakDetectorMSDProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.settings.IPeakDetectorMSDSettings;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.IPeakDetectorSupplier;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.IPeakDetectorSupport;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.PeakDetectorSupplier;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.PeakDetectorSupport;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakDetectorMSD {
    private static final Logger logger = Logger.getLogger(PeakDetectorMSD.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.peak.detector.peakDetectorSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String PEAK_DETECTOR_NAME = "peakDetectorName";
    private static final String PEAK_DETECTOR = "peakDetector";
    private static final String NO_PEAK_DETECTOR_AVAILABLE = "There is no peak detector available.";

    private PeakDetectorMSD() {
    }

    public static IPeakDetectorMSDProcessingInfo detect(IChromatogramSelectionMSD chromatogramSelection, IPeakDetectorMSDSettings peakDetectorSettings, String peakDetectorId, IProgressMonitor monitor) {
        IPeakDetectorMSD peakDetector = PeakDetectorMSD.getPeakDetector(peakDetectorId);
        IPeakDetectorMSDProcessingInfo processingInfo = peakDetector != null ? peakDetector.detect(chromatogramSelection, peakDetectorSettings, monitor) : PeakDetectorMSD.getNoPeakDetectorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakDetectorMSDProcessingInfo detect(IChromatogramSelectionMSD chromatogramSelection, String peakDetectorId, IProgressMonitor monitor) {
        return PeakDetectorMSD.detect(chromatogramSelection, PeakDetectorMSD.getPeakDetector(peakDetectorId), monitor);
    }

    public static IPeakDetectorMSDProcessingInfo detect(IChromatogramSelectionMSD chromatogramSelection, IPeakDetectorMSD peakDetector, IProgressMonitor monitor) {
        IPeakDetectorMSDProcessingInfo processingInfo = peakDetector != null ? peakDetector.detect(chromatogramSelection, monitor) : PeakDetectorMSD.getNoPeakDetectorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakDetectorSupport getPeakDetectorSupport() {
        IConfigurationElement[] extensions;
        PeakDetectorSupport peakDetectorSupport = new PeakDetectorSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(ID);
            String description = element.getAttribute(DESCRIPTION);
            String peakDetectorName = element.getAttribute(PEAK_DETECTOR_NAME);
            PeakDetectorSupplier supplier = new PeakDetectorSupplier(id, description, peakDetectorName);
            peakDetectorSupport.add((IPeakDetectorSupplier)supplier);
            ++n2;
        }
        return peakDetectorSupport;
    }

    private static IPeakDetectorMSD getPeakDetector(String peakDetectorId) {
        IConfigurationElement element = PeakDetectorMSD.getConfigurationElement(peakDetectorId);
        IPeakDetectorMSD instance = null;
        if (element != null) {
            try {
                instance = (IPeakDetectorMSD)element.createExecutableExtension(PEAK_DETECTOR);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String peakDetectorId) {
        IConfigurationElement[] elements;
        if ("".equals(peakDetectorId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(peakDetectorId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IPeakDetectorMSDProcessingInfo getNoPeakDetectorAvailableProcessingInfo() {
        PeakDetectorMSDProcessingInfo processingInfo = new PeakDetectorMSDProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Peak Detector MSD", NO_PEAK_DETECTOR_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

