/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components;

import java.util.List;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.notifier.IStackedPeakSelectionUpdateNotifier;
import org.eclipse.chemclipse.swt.ui.components.AbstractLineSeriesUI;
import org.eclipse.chemclipse.swt.ui.series.ISeriesSetter;
import org.eclipse.chemclipse.swt.ui.support.ChartUtil;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IAxis;
import org.swtchart.Range;

public abstract class AbstractStackedPeakLineSeriesUI
extends AbstractLineSeriesUI
implements ISeriesSetter,
KeyListener,
MouseListener,
IStackedPeakSelectionUpdateNotifier {
    protected List<IPeakMSD> peakListMSD;

    public AbstractStackedPeakLineSeriesUI(Composite parent, int style, IAxisTitles axisTitles) {
        super(parent, style, axisTitles);
    }

    public void update(List<IPeakMSD> peakListMSD, boolean forceReload) {
        this.peakListMSD = peakListMSD;
        if (!this.isMaster() || this.isMaster() && forceReload) {
            double maxSignal = this.calculateMaxSignal();
            this.setMaxSignal(maxSignal);
            this.setSeries(forceReload);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private void setSeries(boolean forceReload) {
        this.deleteAllCurrentSeries();
        this.setViewSeries();
        this.getAxisSet().adjustRange();
        this.setSecondaryRanges();
        this.redraw();
    }

    private void setSecondaryRanges() {
        assert (this.getXAxisBottom() != null) : "The minutes instance must be not null.";
        assert (this.getYAxisRight() != null) : "The relativeAbundance instance must be not null.";
        Range range = this.calculateMinAndMaxRetentionTime();
        this.getXAxisBottom().setRange(range);
        double min = ChartUtil.getRelativeAbundance((double)this.getMaxSignal(), (double)0.0);
        double max = ChartUtil.getRelativeAbundance((double)this.getMaxSignal(), (double)this.calculateMaxSignal());
        range = new Range(min, max);
        this.getYAxisRight().setRange(range);
    }

    public void redrawXAxisBottomScale() {
        assert (this.getXAxisTop() != null) : "The xAxisTop instance must be not null.";
        assert (this.getXAxisBottom() != null) : "The xAxisBottom instance must be not null.";
        Range range = this.getXAxisTop().getRange();
        double min = range.lower / 60000.0;
        double max = range.upper / 60000.0;
        ChartUtil.setRange((IAxis)this.getXAxisBottom(), (double)min, (double)max);
    }

    private double calculateMaxSignal() {
        double maxSignal = 0.0;
        for (IPeakMSD peak : this.peakListMSD) {
            IPeakModelMSD peakModel = peak.getPeakModel();
            double peakSignal = peakModel.getPeakAbundance() + peakModel.getBackgroundAbundance();
            if (!(peakSignal > maxSignal)) continue;
            maxSignal = peakSignal;
        }
        return maxSignal;
    }

    private Range calculateMinAndMaxRetentionTime() {
        int minRetentionTime = Integer.MAX_VALUE;
        int maxRetentionTime = Integer.MIN_VALUE;
        for (IPeakMSD peak : this.peakListMSD) {
            IPeakModelMSD peakModel = peak.getPeakModel();
            int startRetentionTime = peakModel.getStartRetentionTime();
            int stopRetentionTime = peakModel.getStopRetentionTime();
            if (startRetentionTime < minRetentionTime) {
                minRetentionTime = startRetentionTime;
            }
            if (stopRetentionTime <= maxRetentionTime) continue;
            maxRetentionTime = stopRetentionTime;
        }
        double minRetentionTimeMinutes = (double)minRetentionTime / 60000.0;
        double maxRetentionTimeMinutes = (double)maxRetentionTime / 60000.0;
        return new Range(minRetentionTimeMinutes, maxRetentionTimeMinutes);
    }
}

