/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.chromatogram;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.widgets.figures.IntensityGraphFigure;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ChromatogramHeatmapUI
extends Composite {
    private static final Logger logger = Logger.getLogger(ChromatogramHeatmapUI.class);
    private LightweightSystem lightweightSystem;
    private IntensityGraphFigure intensityGraphFigure;
    private Label heatmapTitel;
    private Composite header;

    public ChromatogramHeatmapUI(Composite parent, int style) {
        super(parent, style);
        this.initialize(parent);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        try {
            ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
            IExtractedIonSignals extractedIonSignals = extractedIonSignalExtractor.getExtractedIonSignals(chromatogramSelection);
            this.heatmapTitel.setText("Run: " + chromatogram.getName());
            int startScan = extractedIonSignals.getStartScan();
            int stopScan = extractedIonSignals.getStopScan();
            int startIon = extractedIonSignals.getStartIon();
            int stopIon = extractedIonSignals.getStopIon();
            int dataHeight = stopScan - startScan + 1;
            int dataWidth = stopIon - startIon + 1;
            if (dataHeight < 1 || dataWidth < 1) {
                return;
            }
            float maxIntensity = 0.0f;
            float[] heatmapData = new float[dataWidth * dataHeight * 2];
            int scan = startScan;
            while (scan <= stopScan) {
                int xScan = scan - startScan;
                try {
                    IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                    int ion = startIon;
                    while (ion <= stopIon) {
                        int xIon = ion - startIon;
                        float abundance = extractedIonSignal.getAbundance(ion);
                        if (abundance > maxIntensity) {
                            maxIntensity = abundance;
                        }
                        heatmapData[xScan * dataWidth + xIon] = abundance;
                        ++ion;
                    }
                }
                catch (NoExtractedIonSignalStoredException e) {
                    logger.warn((Object)e);
                }
                ++scan;
            }
            this.intensityGraphFigure.getXAxis().setRange(new Range((double)startIon, (double)stopIon));
            this.intensityGraphFigure.getYAxis().setRange(new Range((double)stopScan, (double)startScan));
            this.intensityGraphFigure.setMin(0.0);
            this.intensityGraphFigure.setMax((double)maxIntensity / ((double)dataHeight / 5.0));
            this.intensityGraphFigure.setDataHeight(dataHeight);
            this.intensityGraphFigure.setDataWidth(dataWidth);
            this.intensityGraphFigure.setColorMap(new ColorMap(ColorMap.PredefinedColorMap.JET, true, true));
            this.lightweightSystem.setContents((IFigure)this.intensityGraphFigure);
            this.intensityGraphFigure.setDataArray(heatmapData);
        }
        catch (ChromatogramIsNullException e1) {
            logger.warn((Object)e1);
        }
    }

    private void initialize(Composite parent) {
        Display display = Display.getCurrent();
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData layoutData = new GridData(768);
        this.header = new Composite(composite, 0);
        this.header.setLayout((Layout)new GridLayout(1, true));
        this.header.setLayoutData((Object)layoutData);
        layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        this.heatmapTitel = new Label(this.header, 0x1000000);
        this.heatmapTitel.setForeground(display.getSystemColor(2));
        this.heatmapTitel.setLayoutData((Object)layoutData);
        Font font = new Font((Device)display, "Arial", 12, 1);
        this.heatmapTitel.setFont(font);
        this.heatmapTitel.setText("");
        font.dispose();
        layoutData = new GridData(1808);
        Canvas canvas = new Canvas(composite, 2052);
        canvas.setLayoutData((Object)layoutData);
        canvas.setBackground(display.getSystemColor(1));
        this.lightweightSystem = new LightweightSystem(canvas);
        this.lightweightSystem.getRootFigure().setBackgroundColor(display.getSystemColor(1));
        this.intensityGraphFigure = new IntensityGraphFigure();
        this.intensityGraphFigure.setForegroundColor(display.getSystemColor(2));
        this.intensityGraphFigure.getXAxis().setTitle("m/z");
        this.intensityGraphFigure.getYAxis().setTitle("scan");
    }
}

