/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.peak;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationEntryMSD;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakQuantitationEntriesContentProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakQuantitationEntriesLabelProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakQuantitationEntriesTableComparator;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PeakQuantitationEntriesUI {
    private ExtendedTableViewer tableViewer;
    private PeakQuantitationEntriesTableComparator peakQuantitationEntriesTableComparator;
    private String[] titles = new String[]{"Name", "Chemical Class", "Concentration", "Concentration Unit", "Area", "Ion (0 = TIC)", "Calibration Method", "Cross Zero", "Description"};
    private int[] bounds = new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100};

    public PeakQuantitationEntriesUI(Composite parent, int style) {
        parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new ExtendedTableViewer(parent, 66306);
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)new PeakQuantitationEntriesContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PeakQuantitationEntriesLabelProvider());
        this.peakQuantitationEntriesTableComparator = new PeakQuantitationEntriesTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.peakQuantitationEntriesTableComparator);
        this.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    PeakQuantitationEntriesUI.this.tableViewer.copyToClipboard(PeakQuantitationEntriesUI.this.titles);
                } else if (e.keyCode == 127 && e.stateMask == 0) {
                    PeakQuantitationEntriesUI.this.deleteSelectedQuantitationResults();
                }
            }
        });
        this.initContextMenu();
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void update(IPeakMSD peak, boolean forceReload) {
        if (peak != null) {
            this.tableViewer.setInput((Object)peak);
        }
    }

    public void clear() {
        this.tableViewer.setInput(null);
    }

    public ExtendedTableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", "org.eclipse.chemclipse.msd.swt.ui.components.peak.peakquantitationentriesui.popup");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakQuantitationEntriesUI.this.tableViewer.copyToClipboard(PeakQuantitationEntriesUI.this.titles);
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        PeakQuantitationEntriesUI.this.deleteSelectedQuantitationResults();
                    }
                };
                action.setText("Delete selected quantitation results");
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
    }

    private void deleteSelectedQuantitationResults() {
        Shell shell = Display.getCurrent().getActiveShell();
        MessageBox messageBox = new MessageBox(shell, 456);
        messageBox.setText("Delete Selected Quantitation Results");
        messageBox.setMessage("Do you really want to delete the selected quantitation results?");
        int decision = messageBox.open();
        if (64 == decision) {
            Table table = this.tableViewer.getTable();
            int[] indices = table.getSelectionIndices();
            Object input = this.tableViewer.getInput();
            if (input instanceof IPeakMSD) {
                List<IQuantitationEntry> quantitationEntriesToRemove = this.getQuantitationEntryList(table, indices);
                IPeakMSD peak = (IPeakMSD)input;
                peak.removeQuantitationEntries(quantitationEntriesToRemove);
            }
            table.remove(indices);
        }
    }

    private List<IQuantitationEntry> getQuantitationEntryList(Table table, int[] indices) {
        ArrayList<IQuantitationEntry> quantitationEntryList = new ArrayList<IQuantitationEntry>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IQuantitationEntryMSD) {
                IQuantitationEntryMSD target = (IQuantitationEntryMSD)object;
                quantitationEntryList.add((IQuantitationEntry)target);
            }
            ++n2;
        }
        return quantitationEntryList;
    }
}

